/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.jackson.JSONArray;
import com.huawei.security.validator.util.jackson.JSONException;
import com.huawei.security.validator.util.jackson.JsonJacksonUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

public class JSONObject
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -54719329954411374L;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public static <T> JSONObject fromObject(T obj) throws JSONException {
        ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
        return JSONObject.fromObject(obj, objectMapper);
    }

    public static <T> JSONObject fromObject(T obj, ObjectMapper objectMapper) throws JSONException {
        if (obj == null) {
            return new JSONObject();
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        JSONObject json = new JSONObject();
        try {
            Map ret = null;
            if (obj instanceof String) {
                ret = (Map)objectMapper.readValue(obj.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            } else {
                String jsonString = objectMapper.writeValueAsString(obj);
                ret = (Map)objectMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            if (ret != null) {
                JSONObject.convertProperty(json, ret, null, objectMapper);
            }
        }
        catch (IOException e) {
            LOG.error("[WSF-ParamValidate] Gets JSONObject from object failed.");
            throw new JSONException("Gets JSONObject from object failed.", e);
        }
        return json;
    }

    private static void convertProperty(JSONObject json, Map<String, Object> ret, Set<String> ignoreProperties, ObjectMapper objectMapper) {
        for (Map.Entry<String, Object> entry : ret.entrySet()) {
            String key = entry.getKey();
            if (ignoreProperties != null && ignoreProperties.contains(key)) continue;
            json.properties.put(key, JSONObject.transformValueToJson(entry.getValue(), objectMapper).orElse(null));
        }
    }

    private static <T> Optional<Object> transformValueToJson(T value, ObjectMapper objectMapper) {
        if (value instanceof Map && !(value instanceof JSONObject)) {
            return Optional.ofNullable(JSONObject.fromObject(value, objectMapper));
        }
        if (value instanceof Collection && !(value instanceof JSONArray)) {
            return Optional.ofNullable(JSONArray.fromObject(value, objectMapper));
        }
        return Optional.ofNullable(value);
    }

    public String toString() throws JSONException {
        try {
            ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
            return objectMapper.writeValueAsString(this.properties);
        }
        catch (JsonProcessingException e) {
            LOG.error("[WSF-ParamValidate] Convert JSONObject to string failed.");
            throw new JSONException("Convert JSONObject to string failed.", e);
        }
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Object put(String key, Object value) throws JSONException {
        ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
        if (key == null) {
            LOG.error("[WSF-ParamValidate] The key for putting to JSONObject is empty.");
            throw new JSONException("Json error, The key for putting to JSONObject is empty.");
        }
        if (value == null) {
            LOG.info("[WSF-ParamValidate] The value for putting to JSONObject is empty.");
            return this;
        }
        Object tempValue = null;
        tempValue = value instanceof String ? this.convertStr2Json((String)value, objectMapper).orElse(null) : (value instanceof Map && !(value instanceof JSONObject) ? JSONObject.fromObject(value, objectMapper) : (value instanceof Collection && !(value instanceof JSONArray) ? JSONArray.fromObject(value, objectMapper) : value));
        return this.properties.put(key, tempValue);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) throws JSONException {
        if (map == null) {
            LOG.error("[WSF-ParamValidate] The map for adding to json is null.");
            throw new JSONException("Json error, The map for adding to json is null.");
        }
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    private Optional<Object> convertStr2Json(String value, ObjectMapper objectMapper) {
        try {
            if (value.startsWith("{") && value.endsWith("}")) {
                return Optional.ofNullable(JSONObject.fromObject(value, objectMapper));
            }
            if (value.startsWith("[") && value.endsWith("]")) {
                return Optional.ofNullable(JSONArray.fromObject(value, objectMapper));
            }
            return Optional.ofNullable(value);
        }
        catch (JSONException e) {
            LOG.error("[WSF-ParamValidate] Can't convert string to JSON Object: JSONException.");
            return Optional.of(value);
        }
    }
}

