/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener;

import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public final class JsonProcessUtils {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    private static int getJsonKeyLevel(String completeKey, List<String> needCheckParamList) {
        int length = "#@#".length();
        for (String needCheckParam : needCheckParamList) {
            if (!needCheckParam.startsWith(completeKey)) continue;
            return Integer.parseInt(needCheckParam.substring(needCheckParam.lastIndexOf("#@#") + length));
        }
        return Integer.MAX_VALUE;
    }

    private static List<String> convertParamListFromCurrentKey(List<String> needCheckParamList) {
        ArrayList<String> needCheckParamListFromCurrentKey = new ArrayList<String>();
        for (String xmlParam : needCheckParamList) {
            String xmlParamSub = xmlParam.substring(0, xmlParam.indexOf("#@#"));
            needCheckParamListFromCurrentKey.add(xmlParamSub);
        }
        return needCheckParamListFromCurrentKey;
    }

    public static void jsonTraverse(Map<String, List<String>> dataMap, JsonBaseCore<?> source) throws ParseRequestDataException {
        List<String> listKeyResp = dataMap.get("needCheckParam#@#");
        ArrayDeque elementIter = new ArrayDeque();
        List<String> convertedNeedCheckParamList = JsonProcessUtils.convertParamListFromCurrentKey(listKeyResp);
        HashSet<String> listKey = new HashSet<String>(convertedNeedCheckParamList);
        JsonProcessUtils.reduce(source, listKey, elementIter, dataMap);
        while (!elementIter.isEmpty()) {
            JsonIterator<?> deepestIter = elementIter.getLast();
            if (!deepestIter.hasNext()) {
                JsonProcessUtils.checkJsonKeyComplete(listKeyResp, elementIter, convertedNeedCheckParamList, listKey);
                continue;
            }
            if (deepestIter.peekNode() instanceof Map.Entry) {
                Map.Entry mem = (Map.Entry)deepestIter.next();
                JsonProcessUtils.reduce((JsonBaseCore)mem.getValue(), listKey, elementIter, dataMap);
                continue;
            }
            Object next = deepestIter.next();
            if (!(next instanceof JsonBaseCore)) continue;
            JsonBaseCore val = (JsonBaseCore)next;
            JsonProcessUtils.reduce(val, listKey, elementIter, dataMap);
        }
    }

    private static void checkJsonKeyComplete(List<String> listKeyResp, ArrayDeque<JsonIterator<?>> elementIter, List<String> convertedNeedCheckParamList, HashSet<String> listKey) throws ParseRequestDataException {
        int size = elementIter.size();
        elementIter.removeLast();
        if (convertedNeedCheckParamList.size() != 0) {
            String completeKey = JsonProcessUtils.composeKey(elementIter);
            int level = JsonProcessUtils.getJsonKeyLevel(completeKey, listKeyResp);
            if (level != size) {
                return;
            }
            List<String> relationKeyList = JsonProcessUtils.getListFromDataMapRefKey(completeKey, listKey);
            if (relationKeyList.size() == 0) {
                listKey.clear();
                listKey.addAll(convertedNeedCheckParamList);
            } else {
                LOG.error("[WSF-ParamValidate] JSON data consistency check failed, Missing key :{}.", (Object)LogUtils.cleanLog(relationKeyList.toString()));
                throw new ParseRequestDataException("JSON data consistency check failed.");
            }
        }
    }

    private static List<String> getListFromDataMapRefKey(String completeKey, HashSet<String> remainNeedCheckParamList) {
        ArrayList<String> relationKeyList = new ArrayList<String>();
        for (String remainKey : remainNeedCheckParamList) {
            if (!remainKey.startsWith(completeKey)) continue;
            relationKeyList.add(remainKey);
        }
        return relationKeyList;
    }

    private static void reduce(JsonBaseCore<?> val, HashSet<String> listKey, ArrayDeque<JsonIterator<?>> elementIter, Map<String, List<String>> flattenedMap) {
        if (val.isObject() && val.asObject().iterator().hasNext()) {
            JsonIterator<?> iterator = JsonIterator.getIteratorInstance(val.asObject());
            elementIter.add(iterator);
        } else if (val.isArray() && val.asArray().iterator().hasNext()) {
            elementIter.add(JsonIterator.getIteratorInstance(val.asArray()));
        } else {
            JsonProcessUtils.fillsResultMap(val, listKey, elementIter, flattenedMap);
        }
    }

    private static void fillsResultMap(JsonBaseCore<?> val, HashSet<String> listKey, ArrayDeque<JsonIterator<?>> elementIter, Map<String, List<String>> flattenedMap) {
        String key = JsonProcessUtils.composeKey(elementIter);
        Object value = JsonProcessUtils.getValueType(val).orElse(null);
        List<String> valueList = flattenedMap.get(key);
        if (valueList == null) {
            valueList = new ArrayList<String>();
        }
        if (!(value instanceof List) && !(value instanceof Map)) {
            valueList.add(value == null ? null : String.valueOf(value));
        }
        listKey.remove(key);
        flattenedMap.put(key, valueList);
    }

    private static Optional<Object> getValueType(JsonBaseCore<?> val) {
        if (val.isNull()) {
            return Optional.empty();
        }
        if (val.isArray()) {
            return Optional.of(new ArrayList());
        }
        if (val.isObject()) {
            return Optional.of(new HashMap());
        }
        return Optional.of(val.asString());
    }

    private static String composeKey(Deque<JsonIterator<?>> elementIter) {
        if (elementIter.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (JsonIterator<?> iter : elementIter) {
            Object current = iter.getCurrentNode();
            if (!(current instanceof Map.Entry)) continue;
            String key = (String)((Map.Entry)current).getKey();
            if (sb.length() != 0) {
                sb.append(".");
            }
            sb.append(key);
        }
        return sb.toString();
    }
}

