/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.gson;

import com.google.gson.JsonElement;
import com.huawei.security.validator.util.jsonflattener.JsonArrayCore;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.gson.JsonObject;
import com.huawei.security.validator.util.jsonflattener.gson.JsonValue;
import java.util.Iterator;
import java.util.Objects;

public final class JsonArray
implements JsonArrayCore<JsonValue> {
    private final com.google.gson.JsonArray gsonArray;

    public JsonArray(com.google.gson.JsonArray jsonArray) {
        if (jsonArray == null) {
            throw new UnsupportedOperationException();
        }
        this.gsonArray = jsonArray;
    }

    @Override
    public JsonValue get(int index) {
        return new JsonValue(this.gsonArray.get(index));
    }

    public int hashCode() {
        return this.gsonArray.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonArray)) {
            return false;
        }
        return Objects.equals(this.gsonArray, ((JsonArray)obj).gsonArray);
    }

    public String toString() {
        return this.gsonArray.toString();
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return new GsonJsonValueIterator(this.gsonArray.iterator());
    }

    @Override
    public void add(JsonBaseCore jsonValue) {
        Object source = jsonValue.getSource();
        if (!(source instanceof JsonElement)) {
            throw new UnsupportedOperationException();
        }
        this.gsonArray.add((JsonElement)source);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, JsonBaseCore jsonValue) {
        Object source = jsonValue.getSource();
        if (!(source instanceof JsonElement)) {
            throw new UnsupportedOperationException();
        }
        this.gsonArray.set(index, (JsonElement)source);
    }

    @Override
    public boolean remove(int index) {
        return this.gsonArray.remove(index) != null;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    public JsonArray asArray() {
        return this;
    }

    public JsonValue asValue() {
        return new JsonValue((JsonElement)this.gsonArray);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public Object getSource() {
        return this.gsonArray;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.gsonArray.size();
    }

    @Override
    public boolean isString() {
        return false;
    }

    private static class GsonJsonValueIterator
    implements Iterator<JsonValue> {
        private final Iterator<JsonElement> gsonElementIterator;

        private GsonJsonValueIterator(Iterator<JsonElement> jsonElementIterator) {
            this.gsonElementIterator = jsonElementIterator;
        }

        @Override
        public boolean hasNext() {
            return this.gsonElementIterator.hasNext();
        }

        @Override
        public JsonValue next() {
            return new JsonValue(this.gsonElementIterator.next());
        }
    }
}

