/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.huawei.security.validator.util.jsonflattener.JsonArrayCore;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonObject;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonValue;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public final class JsonArray
implements JsonArrayCore<JsonValue> {
    private final ArrayNode jackSonJsonArray;

    public JsonArray(ArrayNode jsonArray) {
        if (jsonArray == null) {
            throw new UnsupportedOperationException();
        }
        this.jackSonJsonArray = jsonArray;
    }

    @Override
    public JsonValue get(int index) {
        return new JsonValue(this.jackSonJsonArray.get(index));
    }

    public int hashCode() {
        return this.jackSonJsonArray.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonArray)) {
            return false;
        }
        return Objects.equals(this.jackSonJsonArray, ((JsonArray)obj).jackSonJsonArray);
    }

    public String toString() {
        return this.jackSonJsonArray.toString();
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return new JacksonJsonValueIterator(this.jackSonJsonArray.iterator());
    }

    @Override
    public void forEach(Consumer<? super JsonValue> action) {
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public void add(JsonBaseCore jsonValue) {
        Object source = jsonValue.getSource();
        if (!(source instanceof JsonNode)) {
            throw new UnsupportedOperationException();
        }
        this.jackSonJsonArray.add((JsonNode)source);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, JsonBaseCore jsonValue) {
        Object source = jsonValue.getSource();
        if (!(source instanceof JsonNode)) {
            throw new UnsupportedOperationException();
        }
        this.jackSonJsonArray.set(index, (JsonNode)source);
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(int index) {
        return this.jackSonJsonArray.remove(index) != null;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    public JsonValue asValue() {
        return new JsonValue((JsonNode)this.jackSonJsonArray);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public Object getSource() {
        return this.jackSonJsonArray;
    }

    @Override
    public boolean isString() {
        return false;
    }

    public JsonArray asArray() {
        return this;
    }

    @Override
    public int size() {
        return this.jackSonJsonArray.size();
    }

    private static class JacksonJsonValueIterator
    implements Iterator<JsonValue> {
        private final Iterator<JsonNode> jsonValueIterator;

        private JacksonJsonValueIterator(Iterator<JsonNode> jsonValueIterator) {
            this.jsonValueIterator = jsonValueIterator;
        }

        @Override
        public JsonValue next() {
            return new JsonValue(this.jsonValueIterator.next());
        }

        @Override
        public boolean hasNext() {
            return this.jsonValueIterator.hasNext();
        }
    }
}

