/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.checkengine.RuleEngineManager;
import com.huawei.security.checkengine.bean.CheckInputDetail;
import com.huawei.security.checkengine.bean.CheckResult;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.util.CheckTypeEnum;
import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;

public class InjectionAttackValidator
implements Validator {
    private static final String ATTRIBUTE_CHECK_TYPE = "checktype";
    private static final String ATTRIBUTE_DATA_TYPE = "datatype";
    private static final String KEY_PARAMETER_NAME = "InjectionAttack";
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.INJECTION_ATTACK_VALIDATOR.name(), new Object[0]);
            return result;
        }
        CheckInputDetail badData = null;
        ArrayList<CheckTypeEnum> typeList = new ArrayList<CheckTypeEnum>(10);
        if (!EmptyUtils.isEmpty(validateRuleMap)) {
            String checkType = validateRuleMap.get(ATTRIBUTE_CHECK_TYPE);
            String dataType = validateRuleMap.get(ATTRIBUTE_DATA_TYPE);
            badData = this.setBadData(inputValidate, dataType);
            if (EmptyUtils.hasText(checkType)) {
                String[] typeArray;
                for (String type : typeArray = checkType.split(",")) {
                    typeList.add(CheckTypeEnum.getEnumFromString((String)type.trim()));
                }
            }
        }
        try {
            CheckResult checkResult;
            CheckTypeEnum[] checkTypeEnum = null;
            if (!typeList.isEmpty()) {
                checkTypeEnum = typeList.toArray(new CheckTypeEnum[0]);
            }
            if (!(checkResult = RuleEngineManager.maliciousDataCheck(badData, checkTypeEnum)).isValidateResule()) {
                ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.INJECTION_ATTACK_VALIDATOR.name(), new Object[0]);
            }
        }
        catch (RuleLoadingException e) {
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.INJECTION_ATTACK_VALIDATOR.name(), new Object[0]);
        }
        return result;
    }

    private <T> CheckInputDetail setBadData(T inputValidate, String dataType) {
        String[] value = new String[1];
        if (inputValidate instanceof String) {
            value[0] = (String)inputValidate;
        }
        CheckInputDetail badData = new CheckInputDetail();
        HashMap<String, String[]> valueMap = new HashMap<String, String[]>(1);
        valueMap.put(KEY_PARAMETER_NAME, value);
        if (dataType != null && "head".equalsIgnoreCase(dataType.trim())) {
            badData.setHeaderMap(valueMap);
        } else if (dataType != null && "direct".equalsIgnoreCase(dataType.trim())) {
            badData.setServletPath(value[0]);
        } else {
            badData.setParameterMap(valueMap);
        }
        return badData;
    }
}

