/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.ValidatorUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;

public class MaxLengthValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (validateRuleMap == null || validateRuleMap.get("maxLength") == null) {
            LOG.error("[WSF-ParamValidate] MAX_LENGTH_VALIDATOR validate fail. MaxLengthValidator:attribute maxLength config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_LENGTH_VALIDATOR.name(), new Object[0]);
            return result;
        }
        if (validateRuleMap.get("mark") != null && !validateRuleMap.get("mark").equalsIgnoreCase("extend")) {
            LOG.error("[WSF-ParamValidate] MAX_LENGTH_VALIDATOR validate fail. MaxLengthValidator:attribute mark config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_LENGTH_VALIDATOR.name(), new Object[0]);
            return result;
        }
        String maxLengthString = validateRuleMap.get("maxLength");
        String mark = validateRuleMap.get("mark");
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] MAX_LENGTH_VALIDATOR validate fail. Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_LENGTH_VALIDATOR.name(), maxLengthString);
            return result;
        }
        try {
            int inputLength = "extend".equalsIgnoreCase(mark) ? inputValidate.toString().getBytes(StandardCharsets.UTF_8).length : inputValidate.toString().length();
            int maxLength = Integer.parseInt(maxLengthString);
            if (inputLength > maxLength) {
                LOG.error("[WSF-ParamValidate] MAX_LENGTH_VALIDATOR validate fail.");
                ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_LENGTH_VALIDATOR.name(), maxLengthString);
                return result;
            }
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MAX_LENGTH_VALIDATOR validate fail. Set maxLength {} is not valid.", (Object)LogUtils.cleanLog(maxLengthString));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_LENGTH_VALIDATOR.name(), maxLengthString);
            return result;
        }
        return result;
    }
}

