/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import org.slf4j.Logger;

public class PasswdComplexValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        boolean isSpecialUserPasswd;
        ValidatorResult result = new ValidatorResult();
        String errorCode = ValidatorEnum.PASSWORD_COMPLEX_VALIDATOR.name();
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
            return result;
        }
        if (EmptyUtils.isEmpty(validateRuleMap)) {
            LOG.error("[WSF-ParamValidate] PasswdComplexValidator config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
            return result;
        }
        String valueString = String.valueOf(inputValidate);
        if (EmptyUtils.isEmpty(valueString)) {
            this.invalidPasswordHandler(errorKey, errorMessage, result, errorCode);
            return result;
        }
        String specialUser = validateRuleMap.get("specialUser");
        boolean isSpecialUser = "true".equalsIgnoreCase(specialUser);
        boolean isUserPasswd = valueString.length() >= 8 && valueString.length() <= 128;
        boolean bl = isSpecialUserPasswd = valueString.length() >= 10 && valueString.length() <= 128;
        if (isSpecialUser && !isSpecialUserPasswd) {
            this.invalidPasswordHandler(errorKey, errorMessage, result, errorCode);
            return result;
        }
        if (!isSpecialUser && !isUserPasswd) {
            this.invalidPasswordHandler(errorKey, errorMessage, result, errorCode);
            return result;
        }
        if (!this.combinatPasswd(valueString)) {
            this.invalidPasswordHandler(errorKey, errorMessage, result, errorCode);
            return result;
        }
        if (!this.continuationChar(valueString)) {
            this.invalidPasswordHandler(errorKey, errorMessage, result, errorCode);
        }
        return result;
    }

    private void invalidPasswordHandler(String errorKey, String errorMessage, ValidatorResult result, String errorCode) {
        LOG.error("[WSF-ParamValidate] PASSWORD_COMPLEX_VALIDATOR validate fail.");
        ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
    }

    private boolean continuationChar(String valueString) {
        char[] charArray = valueString.toCharArray();
        for (int i = 0; i < charArray.length - 2; ++i) {
            if (charArray[i] != charArray[i + 1] || charArray[i + 1] != charArray[i + 2]) continue;
            return false;
        }
        return true;
    }

    private boolean combinatPasswd(String valueString) {
        char[] valueCharArray;
        String lowCaseChar = "abcdefghijklmnopqrstuvwxyz";
        String topCaseChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String digitalChar = "0123456789";
        String specialChar = "`~!@#$%^&*()-_=+\\|[{}];:'\",<.>/? ";
        int hasLowCase = 0;
        int hasTopCase = 0;
        int hasDigital = 0;
        int hasSpecial = 0;
        for (char valueChar : valueCharArray = valueString.toCharArray()) {
            if (lowCaseChar.indexOf(valueChar) != -1) {
                hasLowCase = 1;
                continue;
            }
            if (topCaseChar.indexOf(valueChar) != -1) {
                hasTopCase = 1;
                continue;
            }
            if (digitalChar.indexOf(valueChar) != -1) {
                hasDigital = 1;
                continue;
            }
            if (specialChar.indexOf(valueChar) != -1) {
                hasSpecial = 1;
                continue;
            }
            LOG.error("[WSF-ParamValidate] The value contains other char.");
            return false;
        }
        return hasLowCase + hasTopCase + hasDigital + hasSpecial >= 3;
    }
}

