/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.ValidatorUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import org.slf4j.Logger;

public class RangeValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (validateRuleMap == null || validateRuleMap.get("minValue") == null || validateRuleMap.get("maxValue") == null) {
            LOG.error("[WSF-ParamValidate] RangeValidator:attribute minValue or maxValue config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.RANGE_VALIDATOR.name(), new Object[0]);
            return result;
        }
        String minConfig = validateRuleMap.get("minValue");
        String maxConfig = validateRuleMap.get("maxValue");
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] RangeValidator:Input validate parameter value is null, so the result is false.");
            String errorCode = ValidatorEnum.RANGE_VALIDATOR.name();
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, minConfig, maxConfig);
            return result;
        }
        try {
            this.inputRangeValidate(inputValidate, result, minConfig, maxConfig);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] RANGE_VALIDATOR validate fail, Parameter is not valid.");
            String errorCode = ValidatorEnum.RANGE_VALIDATOR.name();
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, minConfig, maxConfig);
            return result;
        }
        if (!result.isValidateResule()) {
            LOG.error("[WSF-ParamValidate] RANGE_VALIDATOR validate fail.");
            String errorCode = ValidatorEnum.RANGE_VALIDATOR.name();
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, minConfig, maxConfig);
            return result;
        }
        return result;
    }

    private void inputRangeValidate(Object inputValidate, ValidatorResult result, String minConfig, String maxConfig) {
        String inputString = String.valueOf(inputValidate);
        if (minConfig.contains(".") || maxConfig.contains(".")) {
            BigDecimal minDecimal = new BigDecimal(minConfig);
            BigDecimal maxDecimal = new BigDecimal(maxConfig);
            BigDecimal inputDecimal = new BigDecimal(inputString);
            if (inputDecimal.compareTo(minDecimal) < 0 || inputDecimal.compareTo(maxDecimal) > 0) {
                result.setValidateResule(false);
            }
        } else if (Long.parseLong(inputString) < Long.parseLong(minConfig) || Long.parseLong(inputString) > Long.parseLong(maxConfig)) {
            result.setValidateResule(false);
        }
    }
}

