/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.web;

import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.web.JsonChecker;
import java.util.Deque;
import java.util.LinkedList;

public class DefaultJsonChecker
implements JsonChecker {
    private static final char QUOTE_CHAR = '\"';
    private static final char START_OBJECT = '{';
    private static final char END_OBJECT = '}';
    private static final char START_ARRAY = '[';
    private static final char END_ARRAY = ']';
    private static final char ESCAPE_CHAR = '\\';
    private static final char COMMA = ',';

    @Override
    public boolean preCheck(String jsonStr, int maxObjSize) {
        if (EmptyUtils.isEmpty(jsonStr) || (long)jsonStr.length() < COMMON_CONFIG_BEAN.getMinJsonCheckLength()) {
            return true;
        }
        long jsonObjNum = this.countJsonObjSize(jsonStr);
        if (jsonObjNum == -1L) {
            return false;
        }
        return maxObjSize == Integer.MIN_VALUE ? jsonObjNum <= (long)COMMON_CONFIG_BEAN.getJsonObjMaxSize() : jsonObjNum <= (long)maxObjSize;
    }

    private long countJsonObjSize(String jsonStr) {
        LinkedList<Boolean> validObject = new LinkedList<Boolean>();
        LinkedList<Character> dq = new LinkedList<Character>();
        long count = this.count(jsonStr.replaceAll("[\\s|null]", "").toCharArray(), validObject, dq);
        if (!dq.isEmpty()) {
            return -1L;
        }
        return count;
    }

    private long count(char[] charCopy, Deque<Boolean> validObject, Deque<Character> dq) {
        long count = 0L;
        boolean isInQuote = false;
        int idx = 0;
        while (idx < charCopy.length) {
            this.dealStatus(validObject, charCopy[idx]);
            if (charCopy[idx] == '\\') {
                idx += 2;
                continue;
            }
            if (charCopy[idx] == '\"' || isInQuote) {
                isInQuote = charCopy[idx] == '\"' != isInQuote;
                ++idx;
                continue;
            }
            if ((count = this.getCount(charCopy, validObject, dq, count, idx)) == -1L) {
                return count;
            }
            ++idx;
        }
        return dq.isEmpty() ? count : -1L;
    }

    private long getCount(char[] charCopy, Deque<Boolean> validObject, Deque<Character> dq, long count, int idx) {
        long newCount = count;
        switch (charCopy[idx]) {
            case '{': {
                newCount = this.processLeftBracket(newCount, dq, charCopy[idx]);
                break;
            }
            case '}': {
                if (!this.processRightBracket(dq, '{')) break;
                return -1L;
            }
            case '[': {
                validObject.push(false);
                dq.push(Character.valueOf(charCopy[idx]));
                break;
            }
            case ']': {
                if (this.processRightBracket(dq, '[')) {
                    return -1L;
                }
                newCount = this.getCount(newCount, validObject);
                break;
            }
            case ',': {
                newCount = this.processComma(newCount, validObject, dq);
                break;
            }
        }
        return newCount;
    }

    private void dealStatus(Deque<Boolean> validObject, char curr) {
        if (!validObject.isEmpty() && !validObject.peek().booleanValue()) {
            validObject.pop();
            validObject.push(this.isObjectChar(curr));
        }
    }

    private long processComma(long count, Deque<Boolean> validObject, Deque<Character> dq) {
        long newCount = count;
        if (!dq.isEmpty() && dq.peek().equals(Character.valueOf('[')) && !validObject.isEmpty() && validObject.peek().booleanValue()) {
            ++newCount;
        }
        return newCount;
    }

    private long getCount(long count, Deque<Boolean> validObject) {
        long newCount = count;
        if (!validObject.isEmpty() && validObject.peek().booleanValue()) {
            ++newCount;
        }
        validObject.pop();
        return newCount;
    }

    private boolean isObjectChar(char curr) {
        return curr != '[' && curr != ']' && curr != ',';
    }

    private boolean processRightBracket(Deque<Character> dq, char cha) {
        if (dq.isEmpty() || !dq.peek().equals(Character.valueOf(cha))) {
            return true;
        }
        dq.pop();
        return false;
    }

    private long processLeftBracket(long count, Deque<Character> dq, char curr) {
        long newCount = count;
        if (dq.isEmpty() || !dq.peek().equals(Character.valueOf('['))) {
            ++newCount;
        }
        dq.push(Character.valueOf(curr));
        return newCount;
    }
}

