/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.web;

import com.huawei.security.validator.bean.CommonConfigsBean;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.util.JsonParseFactory;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.JsonUtil;
import com.huawei.security.validator.util.OrgJsonProcess;
import com.huawei.security.validator.web.JsonChecker;
import com.huawei.security.validator.web.JsonCheckerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class JsonParameter
extends Parameter {
    private final CommonConfigsBean commonConfigBean = FileCache.getInstance().getCommonConfigsBean();
    private String jsonString;
    private ValidateRuleBean validateRuleBean;

    public JsonParameter(HttpServletRequest request, String jsonObject, String requestUri) {
        super(requestUri, request.getCharacterEncoding());
        this.jsonString = jsonObject;
    }

    public JsonParameter(ValidateRuleBean bean, HttpServletRequest request, String jsonObject, String requestUri) {
        super(requestUri, request.getCharacterEncoding());
        this.validateRuleBean = bean;
        this.jsonString = jsonObject;
    }

    @Override
    public Object[] getParameterValue(String key) {
        return new Object[0];
    }

    public Map<String, List<String>> getAllParamInfo(List<String> needCheckParamList, List<String> noNeedCheckParamList) throws ParseRequestDataException, ValidateException {
        Object json;
        HashMap<String, List<String>> dataMap = new HashMap<String, List<String>>(16);
        if (this.commonConfigBean.isJsonPreCheck()) {
            int maxObjSize = this.validateRuleBean.getMaxObjSize();
            JsonChecker jsonChecker = JsonCheckerFactory.getJsonChecker();
            if (!jsonChecker.preCheck(this.jsonString, maxObjSize)) {
                throw new ValidateException("JSON data pre check failed.");
            }
        }
        JsonParseInterface jsonParser = JsonParseFactory.getJsonParser();
        if (!this.commonConfigBean.isAllowDuplicateKey()) {
            OrgJsonProcess.checkJsonDuplicateKey(this.jsonString);
        }
        if (jsonParser.isEmptyJson(json = jsonParser.getJsonObject(this.jsonString))) {
            return dataMap;
        }
        JsonUtil.initCheckParamList(needCheckParamList, noNeedCheckParamList, dataMap);
        jsonParser.traverseJsonData(json, dataMap, "");
        if (((String)((List)dataMap.get("checkResult#@#")).get(0)).equals("1")) {
            JsonUtil.cleanCheckParamList(dataMap);
            throw new ValidateException("JSON data consistency check failed.");
        }
        JsonUtil.cleanCheckParamList(dataMap);
        return dataMap;
    }
}

