/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.web;

import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.XMLParamNumberCheckBean;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.util.PathUtil;
import com.huawei.security.validator.util.XMLProcessUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;

public class XmlParameter
extends Parameter {
    private String xmlData;
    private Document doc;

    public XmlParameter() {
        super(null, null);
    }

    public XmlParameter(HttpServletRequest request, String xmlData, String requestUri) {
        super(requestUri, request.getCharacterEncoding());
        this.xmlData = xmlData;
    }

    @Override
    public Object[] getParameterValue(String key) {
        return new Object[0];
    }

    public List<String> parseXmlValue(String xpath) throws ParseRequestDataException {
        if (this.doc == null) {
            this.doc = XMLProcessUtil.getXMLDocument(this.xmlData);
        }
        return XMLProcessUtil.getXMLParamValue(PathUtil.parse(this.doc).orElse(null), this.getNameSpaces(), xpath);
    }

    public Map<String, XMLParamNumberCheckBean> getAllParamInfo() throws ParseRequestDataException {
        this.doc = XMLProcessUtil.getXMLDocument(this.xmlData);
        return XMLProcessUtil.getAllXPath(this.doc);
    }

    public Document getDocument() {
        return this.doc;
    }

    public Map<String, String> getNameSpaces() {
        return PathUtil.getNameSpaces(this.doc);
    }

    public String getXmlData() {
        return this.xmlData;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }
}

