/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.filecontent;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.filecontent.FileContentCheckInterface;
import com.huawei.security.checkengine.util.FileContentCheckUtil;
import com.huawei.security.checkengine.util.ZipCheckParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarContentCheck
implements FileContentCheckInterface {
    private static final Logger LOG = LoggerFactory.getLogger(TarContentCheck.class);
    private static final String START_PATH = FileContentCheckUtil.getStartPath();
    private static byte[] dataBuffer = new byte[512];

    @Override
    public void checkFileContent(InputStream fileContent, BadRequestDefinition checkRule, boolean closeInputStream, Properties overrideProps) throws MultipartCheckException, NotCheckContentException {
        if (checkRule == null) {
            throw new MultipartCheckException("Failed to parse check rules.");
        }
        ZipCheckParameter checkParameter = new ZipCheckParameter(overrideProps, checkRule);
        try (TarArchiveInputStream input = new TarArchiveInputStream(fileContent, "GBK");){
            ArchiveEntry entry = null;
            boolean isTar = false;
            int fileNum = 0;
            long totalSize = 0L;
            while ((entry = input.getNextEntry()) != null) {
                isTar = true;
                boolean isDir = entry.isDirectory();
                FileContentCheckUtil.checkFileName(entry.getName(), isDir, START_PATH, true, checkParameter);
                if (isDir) continue;
                this.checkFileNum(++fileNum, checkParameter.getMaxFileNum());
                totalSize = this.checkFileTotalSize(checkParameter.getMaxSize(), totalSize, input);
            }
            if (!isTar) {
                LOG.error("[WSF-CheckEngine] The input stream type is not tar.");
                throw new NotCheckContentException("Reading tar file content failed.");
            }
        }
        catch (IOException e) {
            LOG.error("[WSF-CheckEngine] Failed to read the tar file for checking.");
            throw new NotCheckContentException("Reading tar file content failed.", e);
        }
        finally {
            if (closeInputStream) {
                try {
                    fileContent.close();
                }
                catch (IOException e) {
                    LOG.error("[WSF-CheckEngine] Failed to close the input stream.");
                }
            }
        }
    }

    private long checkFileTotalSize(long maxSize, long totalSize, TarArchiveInputStream input) throws MultipartCheckException, IOException {
        long result = totalSize;
        int count = -1;
        while ((count = input.read(dataBuffer, 0, 512)) != -1) {
            if ((result += (long)count) <= maxSize) continue;
            LOG.error("[WSF-CheckEngine] File being untared is too big, the max size is: " + maxSize);
            throw new MultipartCheckException("Checking rar file size failed.");
        }
        return result;
    }

    private void checkFileNum(int fileNum, int maxFileNum) throws MultipartCheckException {
        if (fileNum > maxFileNum) {
            LOG.error("[WSF-CheckEngine] Too many files to untar, the max file number is " + maxFileNum);
            throw new MultipartCheckException("Checking rar file numbers failed.");
        }
    }
}

