/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.util;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.util.PropertyUtils;
import java.util.Properties;
import java.util.regex.Pattern;

public final class ZipCheckParameter {
    private long maxSize;
    private int maxFileNum;
    private int maxFileNameLen;
    private int maxPathLen;
    private int maxPathDepth;
    private Pattern validFileName;
    private Pattern validFolderName;

    public ZipCheckParameter() {
    }

    public ZipCheckParameter(Properties overrideProps, BadRequestDefinition checkRules) throws MultipartCheckException {
        this.maxSize = PropertyUtils.getLong("zipBombThresholdTotalSize", overrideProps, checkRules.getZipBombThresholdTotalSize()) * 1024L * 1024L;
        this.maxFileNum = PropertyUtils.getInt("zipBombThresholdFileCount", overrideProps, checkRules.getZipBombThresholdFileCount());
        this.maxFileNameLen = PropertyUtils.getInt("zippedFilenameMaxLen", overrideProps, checkRules.getZippedFilenameMaxLen());
        this.maxPathLen = PropertyUtils.getInt("zippedPathMaxLen", overrideProps, checkRules.getZippedPathMaxLen());
        this.maxPathDepth = PropertyUtils.getInt("zippedPathMaxDepth", overrideProps, checkRules.getZippedPathMaxDepth());
        this.validFileName = PropertyUtils.getPattern("zippedValidFileName", overrideProps, checkRules.getZippedFileNamePattern());
        this.validFolderName = PropertyUtils.getPattern("zippedValidFolderName", overrideProps, checkRules.getZippedFolderNamePattern());
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxFileNum() {
        return this.maxFileNum;
    }

    public void setMaxFileNum(int maxFileNum) {
        this.maxFileNum = maxFileNum;
    }

    public int getMaxFileNameLen() {
        return this.maxFileNameLen;
    }

    public void setMaxFileNameLen(int maxFileNameLen) {
        this.maxFileNameLen = maxFileNameLen;
    }

    public int getMaxPathLen() {
        return this.maxPathLen;
    }

    public void setMaxPathLen(int maxPathLen) {
        this.maxPathLen = maxPathLen;
    }

    public int getMaxPathDepth() {
        return this.maxPathDepth;
    }

    public void setMaxPathDepth(int maxPathDepth) {
        this.maxPathDepth = maxPathDepth;
    }

    public Pattern getValidFileName() {
        return this.validFileName;
    }

    public void setValidFileName(Pattern zippedValidFileName) {
        this.validFileName = zippedValidFileName;
    }

    public Pattern getValidFolderName() {
        return this.validFolderName;
    }

    public void setValidFolderName(Pattern zippedValidFolderName) {
        this.validFolderName = zippedValidFolderName;
    }
}

