/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.content.dao;

import com.huawei.support.icscbb.hwics.common.content.constant.IcsLibraryConstants;
import com.huawei.support.icscbb.hwics.common.content.dao.IcsContentDaoHandler;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.mapper.IcsContentMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.dto.IcsContentQueryDto;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class IcsContentDao
implements IcsLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsContentDao.class);
    @Resource
    private IcsContentMapper icsContentMapper;

    public String createId(IcsContentDo ics) {
        CodeCCUtils.INSTANCE.infoLog(LOG, "createId");
        return IcsContentDaoHandler.getInstance().createId(ics);
    }

    public void createTb() {
        IcsContentDaoHandler.getInstance().createTb(this.icsContentMapper);
    }

    public IcsContentDo create(File file) {
        return IcsContentDaoHandler.getInstance().createIcsDo(file);
    }

    public boolean add(IcsContentDo icsContentDo) {
        return IcsContentDaoHandler.getInstance().add(this.icsContentMapper, icsContentDo);
    }

    public boolean del(String docId) {
        return IcsContentDaoHandler.getInstance().del(this.icsContentMapper, docId);
    }

    public IcsContentDo get(String docId) {
        return IcsContentDaoHandler.getInstance().get(this.icsContentMapper, docId);
    }

    public IcsContentDo getByPath(String filePath) {
        return IcsContentDaoHandler.getInstance().getByPath(this.icsContentMapper, filePath);
    }

    public boolean findIcs(IcsBaseDo newIcs) {
        return IcsContentDaoHandler.getInstance().findIcs(this.icsContentMapper, newIcs);
    }

    public List<IcsContentDo> getByProjectId(String projectId, String lang) {
        return IcsContentDaoHandler.getInstance().getByProjectId(this.icsContentMapper, projectId, lang);
    }

    public List<IcsContentDo> getByProjectIdAndVer(String projectId, String productVersion, String lang) {
        return IcsContentDaoHandler.getInstance().getByProjectIdAndVer(this.icsContentMapper, projectId, productVersion, lang);
    }

    public List<IcsContentDo> getAll(int start, int len) {
        return IcsContentDaoHandler.getInstance().getAll(this.icsContentMapper, start, len);
    }

    public int icsSize() {
        return IcsContentDaoHandler.getInstance().icsSize(this.icsContentMapper);
    }

    public int icsSize(String productName, String productVer) {
        return IcsContentDaoHandler.getInstance().icsSize(this.icsContentMapper, productName, productVer);
    }

    public Set<String> getAllDocId() {
        return IcsContentDaoHandler.getInstance().getAllDocId(this.icsContentMapper);
    }

    public List<IcsContentDo> getAllFromProduct(String productName, String productVer) {
        return IcsContentDaoHandler.getInstance().getAllFromProduct(this.icsContentMapper, productName, productVer);
    }

    public List<IcsContentDo> getList(IcsContentQueryDto icsContentQueryDto) {
        return IcsContentDaoHandler.getInstance().getList(this.icsContentMapper, icsContentQueryDto);
    }

    public List<IcsContentDo> getOldData(int start, int len) {
        return IcsContentDaoHandler.getInstance().getOldData(this.icsContentMapper, start, len);
    }

    public boolean delOldData(String docId) {
        return IcsContentDaoHandler.getInstance().delOldData(this.icsContentMapper, docId);
    }

    public int icsOldDataSize() {
        return IcsContentDaoHandler.getInstance().icsOldDataSize(this.icsContentMapper);
    }

    public IcsContentDo getByVerify(String verify) {
        return IcsContentDaoHandler.getInstance().getByVerify(this.icsContentMapper, verify);
    }

    public void updateVerify(String docId, String verify) {
        IcsContentDaoHandler.getInstance().updateVerify(this.icsContentMapper, docId, verify);
    }

    public void updateAllVerify(String oldVerify, String newVerify) {
        IcsContentDaoHandler.getInstance().updateVerify(this.icsContentMapper, oldVerify, newVerify);
    }

    public List<IcsContentDo> getLastData(int start, int len) {
        return IcsContentDaoHandler.getInstance().getLastData(this.icsContentMapper, start, len);
    }

    public boolean delLastData(String docId) {
        return IcsContentDaoHandler.getInstance().delLastData(this.icsContentMapper, docId);
    }

    public int icsLastDataSize() {
        return IcsContentDaoHandler.getInstance().icsLastDataSize(this.icsContentMapper);
    }

    public boolean checkAtr(IcsContentDo icsContentDo, String fileName) {
        return IcsContentDaoHandler.getInstance().checkAtr(icsContentDo, fileName);
    }
}

