/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.content.dao;

import com.huawei.support.icscbb.hwics.common.content.constant.IcsLibraryConstants;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.mapper.IcsContentMapper;
import com.huawei.support.icscbb.hwics.common.content.parse.SaxIcsLib;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.dto.IcsContentQueryDto;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsContentDaoHandler
implements IcsLibraryConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsContentDaoHandler.class);

    private IcsContentDaoHandler() {
    }

    public static IcsContentDaoHandler getInstance() {
        return IcsContentDaoHandlerHolder.INSTANCE;
    }

    public String createId(IcsContentDo ics) {
        CodeCCUtils.INSTANCE.infoLog(LOG, "createId");
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            int docidint = sr.nextInt(9999);
            String docidSubffix = docidint / 1000 % 10 + "" + docidint / 100 % 10 + "" + docidint / 10 % 10 + "" + docidint % 10;
            return "ICS" + System.currentTimeMillis() + docidSubffix;
        }
        catch (NoSuchAlgorithmException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "createId Error", (Throwable)e);
            return null;
        }
    }

    public void createTb(IcsContentMapper icsContentMapper) {
        try {
            icsContentMapper.createTb();
            icsContentMapper.createContentTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Table 'ICSCONTENT' already exists or create error.", e);
        }
    }

    public void createOldTb(IcsContentMapper icsContentMapper) {
        try {
            icsContentMapper.createOldTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "createOldTb error.", e);
        }
    }

    public void createLastOldTb(IcsContentMapper icsContentMapper) {
        try {
            icsContentMapper.createLastOldTb();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "createLastOldTb error.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IcsContentDo create(File file) {
        IcsContentDo icsContentDo = new IcsContentDo();
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("resources/infocenter_service/profile.xml");
            if (zipEntry == null) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "zipEntry is null");
                icsContentDo.setFlag(false);
                IcsContentDo icsContentDo2 = icsContentDo;
                return icsContentDo2;
            }
            try (InputStream is = zipFile.getInputStream(zipEntry);){
                icsContentDo.setPath(file.getCanonicalPath());
                icsContentDo.setFlag(true);
                SaxIcsLib saxParser = new SaxIcsLib(icsContentDo);
                SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
                return icsContentDo;
            }
        }
        catch (ZipException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "new ZipFile error", (Throwable)e);
            icsContentDo.setFlag(false);
            return icsContentDo;
        }
        catch (FileNotFoundException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "FileNotFoundException error");
            icsContentDo.setFlag(false);
            return icsContentDo;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error", (Throwable)e);
            icsContentDo.setFlag(false);
            return icsContentDo;
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "SAXException error", (Throwable)e);
            icsContentDo.setFlag(false);
        }
        return icsContentDo;
    }

    public IcsContentDo createIcsDo(File file) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "create: " + file.getName());
        IcsContentDo ics = this.create(file);
        if (!ics.isFlag()) {
            return ics;
        }
        if (!this.checkAtr(ics, file.getName())) {
            ics.setFlag(false);
            return ics;
        }
        ics.setDocId(this.createId(ics));
        if (ics.getDocId() == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsContentDAO createId is null.");
            ics.setFlag(false);
            return ics;
        }
        return ics;
    }

    public boolean checkAtr(IcsContentDo ics, String fileName) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{ics.getProductid(), ics.getProductName(), ics.getProductV(), ics.getLibName(), ics.getIssueDate()})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, String.format(Locale.ENGLISH, "One or more attributes of (IssueDate, ProductName, Productid, ProductV, LibName) are missing in the file:%s.", fileName));
            return false;
        }
        return true;
    }

    public boolean add(IcsContentMapper icsContentMapper, IcsContentDo icsContentDo) {
        if (!this.checkAddFlag(icsContentDo)) {
            return false;
        }
        try {
            icsContentMapper.add(icsContentDo);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add Error", e);
            return false;
        }
        return true;
    }

    public boolean addBatch(IcsContentMapper icsContentMapper, List<IcsContentDo> icsContentDos) {
        try {
            icsContentMapper.addBatch(icsContentDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addBatch Error", e);
            return false;
        }
        return true;
    }

    public boolean addOldBatch(IcsContentMapper icsContentMapper, List<IcsContentDo> icsContentDos) {
        try {
            icsContentMapper.addOldBatch(icsContentDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addOldBatch Error", e);
            return false;
        }
        return true;
    }

    public boolean addLastOldBatch(IcsContentMapper icsContentMapper, List<IcsContentDo> icsContentDos) {
        try {
            icsContentMapper.addLastOldBatch(icsContentDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addLastOldBatch Error", e);
            return false;
        }
        return true;
    }

    private boolean checkAddFlag(IcsContentDo icsContentDo) {
        if (icsContentDo.isFlag()) {
            icsContentDo.setbUse(true);
            return true;
        }
        CodeCCUtils.INSTANCE.errorLog(LOG, "icsContentDo add fail.");
        return false;
    }

    public boolean del(IcsContentMapper icsContentMapper, String docId) {
        try {
            icsContentMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del Error", e);
            return false;
        }
        return true;
    }

    public boolean delAll(IcsContentMapper icsContentMapper) {
        try {
            icsContentMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delAll Error", e);
            return false;
        }
        return true;
    }

    public boolean delOldAll(IcsContentMapper icsContentMapper) {
        try {
            icsContentMapper.delOldAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delOldAll Error", e);
            return false;
        }
        return true;
    }

    public boolean delLastOldAll(IcsContentMapper icsContentMapper) {
        try {
            icsContentMapper.delLastOldAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delLastOldAll Error", e);
            return false;
        }
        return true;
    }

    public IcsContentDo get(IcsContentMapper icsContentMapper, String docId) {
        IcsContentDo icsContentDo = null;
        try {
            icsContentDo = icsContentMapper.get(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get ERROR", e);
        }
        return icsContentDo;
    }

    public IcsContentDo getByPath(IcsContentMapper icsContentMapper, String filePath) {
        IcsContentDo icsContentDo = null;
        try {
            icsContentDo = icsContentMapper.getByPath(filePath);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByPath ERROR", e);
        }
        return icsContentDo;
    }

    public boolean findIcs(IcsContentMapper icsContentMapper, IcsBaseDo newIcs) {
        ArrayList<IcsContentDo> icsList = new ArrayList<IcsContentDo>();
        String projectid = newIcs.getProjectid();
        String libV = newIcs.getLibV();
        String lang = newIcs.getLang();
        String issueDate = newIcs.getIssueDate();
        if (projectid == null || lang == null || issueDate == null) {
            return true;
        }
        try {
            icsList.addAll(icsContentMapper.getByIcs(projectid, libV, lang, issueDate));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "findIcs ERROR", e);
        }
        return icsList.size() > 0;
    }

    public List<IcsContentDo> getByProjectId(IcsContentMapper icsContentMapper, String projectId, String lang) {
        ArrayList<IcsContentDo> icsList = new ArrayList<IcsContentDo>();
        try {
            icsList.addAll(icsContentMapper.getByProjectid(projectId, lang));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByProjectId ERROR", e);
        }
        return icsList;
    }

    public List<IcsContentDo> getByProjectIdAndVer(IcsContentMapper icsContentMapper, String projectId, String productVersion, String lang) {
        ArrayList<IcsContentDo> icsList = new ArrayList<IcsContentDo>();
        try {
            icsList.addAll(icsContentMapper.getByProjectidAndVer(projectId, productVersion, lang));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByProjectIdAndVer ERROR", e);
        }
        return icsList;
    }

    public List<IcsContentDo> getAll(IcsContentMapper icsContentMapper, int start, int len) {
        ArrayList<IcsContentDo> icsList = new ArrayList<IcsContentDo>();
        try {
            icsList.addAll(icsContentMapper.getAll(start, len));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAll ERROR", e);
        }
        return icsList;
    }

    public int icsSize(IcsContentMapper icsContentMapper) {
        int size = 0;
        try {
            size = icsContentMapper.icsSize();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsSize ERROR", e);
        }
        return size;
    }

    public int icsSize(IcsContentMapper icsContentMapper, String productName, String productVer) {
        try {
            if (productVer == null || "".equals(productVer)) {
                return icsContentMapper.icsSizeFromProduct(productName, null);
            }
            return icsContentMapper.icsSizeFromProduct(productName, productVer);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsSize ERROR", e);
            return 0;
        }
    }

    public Set<String> getAllDocId(IcsContentMapper icsContentMapper) {
        HashSet<String> docidSet = new HashSet<String>();
        try {
            docidSet.addAll(icsContentMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAllDocId ERROR", e);
        }
        return docidSet;
    }

    public List<IcsContentDo> getAllFromProduct(IcsContentMapper icsContentMapper, String productName, String productVer) {
        ArrayList<IcsContentDo> icsList = new ArrayList<IcsContentDo>();
        try {
            if (productVer == null || "".equals(productVer)) {
                icsList.addAll(icsContentMapper.getAllFromProduct(productName, null));
            } else {
                icsList.addAll(icsContentMapper.getAllFromProduct(productName, productVer));
            }
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAll ERROR", e);
        }
        return icsList;
    }

    public List<IcsContentDo> getList(IcsContentMapper icsContentMapper, IcsContentQueryDto icsContentQueryDto) {
        ArrayList<IcsContentDo> icsContentDoList = new ArrayList<IcsContentDo>();
        try {
            icsContentDoList.addAll(icsContentMapper.getList(icsContentQueryDto));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getList ERROR", e);
        }
        return icsContentDoList;
    }

    public List<IcsContentDo> getOldData(IcsContentMapper icsContentMapper, int start, int len) {
        ArrayList<IcsContentDo> icsContentDoList = new ArrayList<IcsContentDo>();
        try {
            icsContentDoList.addAll(icsContentMapper.getOldData(start, len));
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getOldData ERROR", e);
        }
        return icsContentDoList;
    }

    public boolean delOldData(IcsContentMapper icsContentMapper, String docId) {
        try {
            icsContentMapper.delOldData(docId);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delOldData Error", e);
            return false;
        }
        return true;
    }

    public int icsOldDataSize(IcsContentMapper icsContentMapper) {
        int size = 0;
        try {
            size = icsContentMapper.icsOldDataSize();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "icsOldDataSize ERROR", e);
        }
        return size;
    }

    public IcsContentDo getByVerify(IcsContentMapper icsContentMapper, String verify) {
        IcsContentDo icsContentDo = null;
        try {
            icsContentDo = icsContentMapper.getByVerify(verify);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByPath ERROR", e);
        }
        return icsContentDo;
    }

    public void updateVerify(IcsContentMapper icsContentMapper, String docId, String verify) {
        try {
            icsContentMapper.updateVerify(docId, verify);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateVerify ERROR", e);
        }
    }

    public void updateAllVerify(IcsContentMapper icsContentMapper, String oldVerify, String newVerify) {
        try {
            icsContentMapper.updateAllVerify(oldVerify, newVerify);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateAllVerify ERROR", e);
        }
    }

    public List<IcsContentDo> getLastData(IcsContentMapper icsContentMapper, int start, int len) {
        ArrayList<IcsContentDo> icsContentDoList = new ArrayList<IcsContentDo>();
        try {
            icsContentDoList.addAll(icsContentMapper.getLastData(start, len));
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getLastData ERROR", e);
        }
        return icsContentDoList;
    }

    public boolean delLastData(IcsContentMapper icsContentMapper, String docId) {
        try {
            icsContentMapper.delLastData(docId);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delLastData Error", e);
            return false;
        }
        return true;
    }

    public int icsLastDataSize(IcsContentMapper icsContentMapper) {
        int size = 0;
        try {
            size = icsContentMapper.icsLastDataSize();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "icsLastDataSize ERROR", e);
        }
        return size;
    }

    public List<IcsContentDo> getIcsList(IcsContentMapper icsContentMapper, List<IcsContentDo> icsContentDoList) {
        ArrayList<IcsContentDo> icsContentDos = new ArrayList<IcsContentDo>();
        try {
            icsContentDos.addAll(icsContentMapper.getIcsList(icsContentDoList));
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getIcsList ERROR", e);
        }
        return icsContentDos;
    }

    private static class IcsContentDaoHandlerHolder {
        private static final IcsContentDaoHandler INSTANCE = new IcsContentDaoHandler();

        private IcsContentDaoHandlerHolder() {
        }
    }
}

