/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.content.service.impl;

import com.huawei.support.icscbb.hwics.common.content.dao.IcsContentDaoHandler;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.mapper.IcsContentMapper;
import com.huawei.support.icscbb.hwics.common.content.service.IcsContentService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.dto.IcsContentQueryDto;
import com.huawei.support.icscbb.util.pool.LibEntityPool;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsContentPoolServiceHandler
extends LibEntityPool<IcsContentDo>
implements IcsContentService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsContentPoolServiceHandler.class);
    private static final IcsContentMapper ICS_CONTENT_MAPPER = (IcsContentMapper)DbMapperUtils.getMapper(IcsContentMapper.class);
    private static final int MIN_INDEX = 10;
    private static final int MAX_INDEX = 100;

    private IcsContentPoolServiceHandler() {
    }

    public static IcsContentPoolServiceHandler getInstance() {
        return IcsContentPoolServiceHandlerHolder.INSTANCE;
    }

    public void initPool() {
        int icsSize = IcsContentDaoHandler.getInstance().icsSize(ICS_CONTENT_MAPPER);
        int stepIndex = 1000;
        int icsMinIndex = 0;
        ArrayList<String> docIdlist = new ArrayList<String>();
        while (icsSize - icsMinIndex > 0) {
            List<IcsContentDo> icsContentlist = IcsContentDaoHandler.getInstance().getAll(ICS_CONTENT_MAPPER, icsMinIndex, 1000);
            for (IcsContentDo icsContentDo : icsContentlist) {
                if (docIdlist.contains(icsContentDo.getDocId())) {
                    icsContentDo.setbUse(false);
                }
                super.addPool(icsContentDo.getDocId(), (Object)icsContentDo);
                docIdlist.add(icsContentDo.getDocId());
            }
            icsMinIndex += stepIndex;
        }
    }

    protected void createPool(String key) {
        IcsContentDo icsContentDo = IcsContentDaoHandler.getInstance().get(ICS_CONTENT_MAPPER, key);
        if (icsContentDo != null) {
            super.addPool(key, (Object)icsContentDo);
        }
    }

    public void addPool(IcsContentDo icsContentDo) {
        super.addPool(icsContentDo.getDocId(), (Object)icsContentDo);
    }

    public IcsContentDo delPool(String key) {
        return (IcsContentDo)((Object)super.delPool(key));
    }

    public List<IcsContentDo> getAllPool(String productName, String productVer) {
        ArrayList<IcsContentDo> pool = new ArrayList<IcsContentDo>();
        ArrayList icsContentDoList = new ArrayList(this.objectMap.values());
        for (IcsContentDo icsContentDo : icsContentDoList) {
            if (!icsContentDo.isbUse() || productName != null && !"".equals(productName) && !icsContentDo.getProductName().equals(productName) || productVer != null && !"".equals(productVer) && !icsContentDo.getProductV().equals(productVer)) continue;
            pool.add(icsContentDo);
        }
        return pool;
    }

    public int poolSize(String productName, String productVer) {
        int time = 0;
        ArrayList icsContentDoList = new ArrayList(this.objectMap.values());
        for (IcsContentDo icsContentDo : icsContentDoList) {
            if (!icsContentDo.isbUse() || productName != null && !"".equals(productName) && !productName.equals(icsContentDo.getProductName()) || productVer != null && !"".equals(productVer) && !productVer.equals(icsContentDo.getProductV())) continue;
            ++time;
        }
        return time;
    }

    private void getAllPoolProduct(Map<String, Set<String>> map) {
        ArrayList icsContentDoList = new ArrayList(this.objectMap.values());
        for (IcsContentDo icsContentDo : icsContentDoList) {
            Set productVerSet;
            if (!icsContentDo.isbUse() || (productVerSet = map.computeIfAbsent(icsContentDo.getProductName(), productVer -> new LinkedHashSet())) == null) continue;
            productVerSet.add(icsContentDo.getProductV());
        }
    }

    @Override
    public void createTb() {
        IcsContentDaoHandler.getInstance().createTb(ICS_CONTENT_MAPPER);
    }

    @Override
    public void createOldTb() {
        IcsContentDaoHandler.getInstance().createOldTb(ICS_CONTENT_MAPPER);
    }

    @Override
    public void createLastOldTb() {
        IcsContentDaoHandler.getInstance().createLastOldTb(ICS_CONTENT_MAPPER);
    }

    @Override
    public IcsContentDo create(File file) {
        return IcsContentDaoHandler.getInstance().createIcsDo(file);
    }

    @Override
    public boolean add(IcsContentDo icsContentDo) {
        if (IcsContentDaoHandler.getInstance().add(ICS_CONTENT_MAPPER, icsContentDo)) {
            this.addPool(icsContentDo);
            return true;
        }
        return false;
    }

    @Override
    public boolean addBatch(List<IcsContentDo> icsContentDos) {
        return IcsContentDaoHandler.getInstance().addBatch(ICS_CONTENT_MAPPER, icsContentDos);
    }

    @Override
    public boolean addOldBatch(List<IcsContentDo> icsContentDos) {
        return IcsContentDaoHandler.getInstance().addOldBatch(ICS_CONTENT_MAPPER, icsContentDos);
    }

    @Override
    public boolean addLastOldBatch(List<IcsContentDo> icsContentDos) {
        return IcsContentDaoHandler.getInstance().addLastOldBatch(ICS_CONTENT_MAPPER, icsContentDos);
    }

    @Override
    public boolean findIcs(IcsBaseDo ics) {
        return IcsContentDaoHandler.getInstance().findIcs(ICS_CONTENT_MAPPER, ics);
    }

    @Override
    public boolean del(String docId) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty.");
            return false;
        }
        this.delPool(docId);
        return IcsContentDaoHandler.getInstance().del(ICS_CONTENT_MAPPER, docId);
    }

    @Override
    public boolean delAll() {
        return IcsContentDaoHandler.getInstance().delAll(ICS_CONTENT_MAPPER);
    }

    @Override
    public boolean delOldAll() {
        return IcsContentDaoHandler.getInstance().delOldAll(ICS_CONTENT_MAPPER);
    }

    @Override
    public boolean delLastOldAll() {
        return IcsContentDaoHandler.getInstance().delLastOldAll(ICS_CONTENT_MAPPER);
    }

    @Override
    public IcsContentDo get(String docId) {
        return (IcsContentDo)((Object)this.getPool(docId));
    }

    @Override
    public IcsContentDo getByPath(String zipFilePath) {
        if (StringUtils.isEmpty((CharSequence)zipFilePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "filePath is Empty.");
            return null;
        }
        return IcsContentDaoHandler.getInstance().getByPath(ICS_CONTENT_MAPPER, zipFilePath);
    }

    @Override
    public List<IcsContentDo> getByProjectid(String projectid, String lang) {
        ArrayList<IcsContentDo> icsContentList = new ArrayList<IcsContentDo>();
        if (projectid == null || lang == null) {
            return icsContentList;
        }
        icsContentList.addAll(IcsContentDaoHandler.getInstance().getByProjectId(ICS_CONTENT_MAPPER, projectid, lang));
        return icsContentList;
    }

    @Override
    public List<IcsContentDo> getByProjectidAndVer(String projectid, String productversion, String lang) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{projectid, productversion, lang})) {
            return Collections.emptyList();
        }
        return IcsContentDaoHandler.getInstance().getByProjectIdAndVer(ICS_CONTENT_MAPPER, projectid, productversion, lang);
    }

    @Override
    public List<IcsContentDo> getAll(String productName, String productVer) {
        return this.getAllPool(productName, productVer);
    }

    @Override
    public List<IcsContentDo> getOldAll(int start, int len) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAll, start: " + start + " len:" + len);
        int myStart = Math.max(start, 0);
        int myLen = len <= 0 ? 10 : len;
        myLen = myLen > 100 ? 10 : myLen;
        return new ArrayList<IcsContentDo>(this.getAllOldPool(myStart, myLen));
    }

    @Override
    public int icsSize(String productName, String productVer) {
        return this.poolSize(productName, productVer);
    }

    @Override
    public int icsOldSize() {
        return this.poolOldSize();
    }

    @Override
    public void getAllProduct(Map<String, Set<String>> map) {
        this.getAllPoolProduct(map);
    }

    @Override
    public Set<String> getAllDocId() {
        return IcsContentDaoHandler.getInstance().getAllDocId(ICS_CONTENT_MAPPER);
    }

    @Override
    public boolean checkAtr(IcsContentDo icsContentDo, String fileName) {
        return IcsContentDaoHandler.getInstance().checkAtr(icsContentDo, fileName);
    }

    @Override
    public List<IcsContentDo> getList(IcsContentQueryDto icsContentQueryDto) {
        return null;
    }

    @Override
    public boolean setUpdate(String docId, boolean bUpdate) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty");
            return false;
        }
        IcsContentDo icsContentDo = (IcsContentDo)((Object)this.getPool(docId));
        if (icsContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsContentDo is null");
            return false;
        }
        icsContentDo.setbUpdate(bUpdate);
        return true;
    }

    @Override
    public void updateIcsLibData() {
        int icsSize = IcsContentDaoHandler.getInstance().icsOldDataSize(ICS_CONTENT_MAPPER);
        int icsLastSize = IcsContentDaoHandler.getInstance().icsLastDataSize(ICS_CONTENT_MAPPER);
        if (icsSize > 0) {
            this.dealOldData(icsSize);
        }
        if (icsLastSize > 0) {
            this.dealLastData(icsLastSize);
        }
    }

    private void dealOldData(int icsSize) {
        int stepIndex = 100;
        int icsMinIndex = 0;
        int icsMaxIndex = 100;
        while (icsSize - icsMinIndex > 0) {
            List<IcsContentDo> icsOldDoList = IcsContentDaoHandler.getInstance().getOldData(ICS_CONTENT_MAPPER, icsMinIndex, icsMaxIndex);
            this.syncIcs(icsOldDoList, "ORIGINALTABLE");
            icsMinIndex += stepIndex;
        }
    }

    private void dealLastData(int icsLastSize) {
        int stepIndex = 100;
        int icsMinIndex = 0;
        int icsMaxIndex = 100;
        while (icsLastSize - icsMinIndex > 0) {
            List<IcsContentDo> icsOldDoList = IcsContentDaoHandler.getInstance().getLastData(ICS_CONTENT_MAPPER, icsMinIndex, icsMaxIndex);
            this.syncIcs(icsOldDoList, "LASTTABLE");
            icsMinIndex += stepIndex;
        }
    }

    private void syncIcs(List<IcsContentDo> icsOldDoList, String dataType) {
        if (CollectionUtils.isEmpty(icsOldDoList)) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "icsOldDoList is null");
            return;
        }
        for (IcsContentDo icsOldDo : icsOldDoList) {
            boolean checkData = this.checkNewData(icsOldDo.getDocId());
            if (checkData) {
                this.delOldLibData(icsOldDo.getDocId(), dataType);
                continue;
            }
            File file = FileUtils.getFile((String[])new String[]{icsOldDo.getPath()});
            IcsContentDo icsNewDo = IcsContentDaoHandler.getInstance().create(file);
            if (!icsNewDo.isFlag()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to parse the file: " + file.getName());
                continue;
            }
            if (!this.checkAtr(icsNewDo, file.getName())) {
                icsNewDo.setFlag(false);
                continue;
            }
            icsNewDo.setDocId(icsOldDo.getDocId());
            boolean result = this.add(icsNewDo);
            if (result && StringUtils.equals((CharSequence)"ORIGINALTABLE", (CharSequence)dataType)) {
                this.delOldLibData(icsOldDo.getDocId(), dataType);
            }
            if (!result || !StringUtils.equals((CharSequence)"LASTTABLE", (CharSequence)dataType)) continue;
            this.delOldLibData(icsOldDo.getDocId(), dataType);
        }
    }

    @Override
    public void updateVerify(String docId, String verify) {
        IcsContentDo icsContentDo = (IcsContentDo)((Object)this.getPool(docId));
        if (icsContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsContentDo is null");
            return;
        }
        icsContentDo.setVerify(verify);
        IcsContentDaoHandler.getInstance().updateVerify(ICS_CONTENT_MAPPER, docId, verify);
    }

    @Override
    public IcsContentDo getByVerify(String verify) {
        IcsContentDo icsContentDo = null;
        if (StringUtils.isEmpty((CharSequence)verify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "verify isEmpty.");
            return icsContentDo;
        }
        return IcsContentDaoHandler.getInstance().getByVerify(ICS_CONTENT_MAPPER, verify);
    }

    @Override
    public void updateAllVerify(String oldVerify, String newVerify) {
        if (StringUtils.isEmpty((CharSequence)oldVerify) || StringUtils.isEmpty((CharSequence)newVerify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "oldVerify or newVerify isEmpty.");
        }
        IcsContentDaoHandler.getInstance().updateAllVerify(ICS_CONTENT_MAPPER, oldVerify, newVerify);
    }

    @Override
    public List<IcsContentDo> getIcsList(List<IcsContentDo> icsContentDoList) {
        if (CollectionUtils.isEmpty(icsContentDoList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsContentDoList isEmpty.");
            return new ArrayList<IcsContentDo>();
        }
        return IcsContentDaoHandler.getInstance().getIcsList(ICS_CONTENT_MAPPER, icsContentDoList);
    }

    @Override
    public boolean setProfileHdxProp(String docId, String hdx) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "setHdx docId is Empty");
            return false;
        }
        IcsContentDo icsContentDo = (IcsContentDo)((Object)this.getPool(docId));
        if (icsContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "setHdx icsContentDo is null");
            return false;
        }
        icsContentDo.setHdx(hdx);
        return true;
    }

    private boolean checkNewData(String docId) {
        IcsContentDo icsContentDo = IcsContentDaoHandler.getInstance().get(ICS_CONTENT_MAPPER, docId);
        return icsContentDo != null;
    }

    private void delOldLibData(String docId, String dataType) {
        if (StringUtils.equals((CharSequence)"ORIGINALTABLE", (CharSequence)dataType)) {
            IcsContentDaoHandler.getInstance().delOldData(ICS_CONTENT_MAPPER, docId);
        }
        if (StringUtils.equals((CharSequence)"LASTTABLE", (CharSequence)dataType)) {
            IcsContentDaoHandler.getInstance().delLastData(ICS_CONTENT_MAPPER, docId);
        }
    }

    private static class IcsContentPoolServiceHandlerHolder {
        private static final IcsContentPoolServiceHandler INSTANCE = new IcsContentPoolServiceHandler();

        private IcsContentPoolServiceHandlerHolder() {
        }
    }
}

