/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.content.service.impl;

import com.huawei.support.icscbb.hwics.common.content.dao.IcsContentDao;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.IcsContentService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.dto.IcsContentQueryDto;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Service;

@Service(value="icsContentServiceImpl")
@ComponentScan(basePackages={"com.huawei.support.hwics"})
public class IcsContentServiceImpl
implements IcsContentService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsContentServiceImpl.class);
    private static final int MIN_INDEX = 10;
    private static final int MAX_INDEX = 100;
    @Resource
    private IcsContentDao icsContentDao;

    @Override
    public void createTb() {
        this.icsContentDao.createTb();
    }

    @Override
    public void createOldTb() {
    }

    @Override
    public void createLastOldTb() {
    }

    @Override
    public IcsContentDo create(File file) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "create: " + file.getName());
        return this.icsContentDao.create(file);
    }

    @Override
    public boolean add(IcsContentDo ics) {
        return this.icsContentDao.add(ics);
    }

    @Override
    public boolean addBatch(List<IcsContentDo> icsContentDos) {
        return false;
    }

    @Override
    public boolean addOldBatch(List<IcsContentDo> icsContentDos) {
        return false;
    }

    @Override
    public boolean addLastOldBatch(List<IcsContentDo> icsContentDos) {
        return false;
    }

    @Override
    public boolean findIcs(IcsBaseDo ics) {
        return this.icsContentDao.findIcs(ics);
    }

    @Override
    public boolean del(String docId) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty.");
            return false;
        }
        return this.icsContentDao.del(docId);
    }

    @Override
    public boolean delAll() {
        return false;
    }

    @Override
    public boolean delOldAll() {
        return false;
    }

    @Override
    public boolean delLastOldAll() {
        return false;
    }

    @Override
    public IcsContentDo get(String docId) {
        if (docId == null) {
            return null;
        }
        return this.icsContentDao.get(docId);
    }

    @Override
    public IcsContentDo getByPath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "filePath is Empty.");
            return null;
        }
        return this.icsContentDao.getByPath(filePath);
    }

    @Override
    public List<IcsContentDo> getByProjectid(String projectid, String lang) {
        ArrayList<IcsContentDo> icsContentList = new ArrayList<IcsContentDo>();
        if (projectid == null || lang == null) {
            return icsContentList;
        }
        icsContentList.addAll(this.icsContentDao.getByProjectId(projectid, lang));
        return icsContentList;
    }

    @Override
    public List<IcsContentDo> getByProjectidAndVer(String projectid, String productversion, String lang) {
        ArrayList<IcsContentDo> icsContentList = new ArrayList<IcsContentDo>();
        if (projectid == null || productversion == null || lang == null) {
            return icsContentList;
        }
        icsContentList.addAll(this.icsContentDao.getByProjectIdAndVer(projectid, productversion, lang));
        return icsContentList;
    }

    @Override
    public List<IcsContentDo> getAll(String productName, String productVer) {
        CodeCCUtils.INSTANCE.debugLog(LOG, String.format(Locale.ENGLISH, "getAll, productName:%s ,productVer:%s", productName, productVer));
        return new ArrayList<IcsContentDo>(this.icsContentDao.getAllFromProduct(productName, productVer));
    }

    @Override
    public List<IcsContentDo> getOldAll(int start, int len) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAll, start: " + start + " len:" + len);
        int myStart = Math.max(start, 0);
        int myLen = len <= 0 ? 10 : len;
        myLen = myLen > 100 ? 10 : myLen;
        return new ArrayList<IcsContentDo>(this.icsContentDao.getAll(myStart, myLen));
    }

    @Override
    public int icsSize(String productName, String productVer) {
        return this.icsContentDao.icsSize(productName, productVer);
    }

    @Override
    public int icsOldSize() {
        return this.icsContentDao.icsSize();
    }

    @Override
    public void getAllProduct(Map<String, Set<String>> map) {
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        return new HashSet<String>(this.icsContentDao.getAllDocId());
    }

    @Override
    public boolean checkAtr(IcsContentDo ics, String fileName) {
        return this.icsContentDao.checkAtr(ics, fileName);
    }

    @Override
    public List<IcsContentDo> getList(IcsContentQueryDto icsContentQueryDto) {
        ArrayList<IcsContentDo> icsContentDoList = new ArrayList<IcsContentDo>();
        if (icsContentQueryDto == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get getList failed, icsContentQueryDto is null");
            return icsContentDoList;
        }
        return this.icsContentDao.getList(icsContentQueryDto);
    }

    @Override
    public boolean setUpdate(String docId, boolean bUpdate) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null");
            return false;
        }
        IcsContentDo icsContentDo = this.icsContentDao.get(docId);
        if (icsContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsContentDo is null");
            return false;
        }
        icsContentDo.setbUpdate(bUpdate);
        return true;
    }

    @Override
    public void updateIcsLibData() {
    }

    @Override
    public void updateVerify(String docId, String verify) {
        if (StringUtils.isEmpty((CharSequence)docId) || StringUtils.isEmpty((CharSequence)verify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or verify isEmpty.");
        }
        this.icsContentDao.updateVerify(docId, verify);
    }

    @Override
    public IcsContentDo getByVerify(String verify) {
        IcsContentDo icsContentDo = null;
        if (StringUtils.isEmpty((CharSequence)verify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "verify isEmpty.");
            return icsContentDo;
        }
        return this.icsContentDao.getByVerify(verify);
    }

    @Override
    public void updateAllVerify(String oldVerify, String newVerify) {
        if (StringUtils.isEmpty((CharSequence)oldVerify) || StringUtils.isEmpty((CharSequence)newVerify)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "oldVerify or newVerify isEmpty.");
        }
        this.icsContentDao.updateAllVerify(oldVerify, newVerify);
    }

    @Override
    public List<IcsContentDo> getIcsList(List<IcsContentDo> icsContentDoList) {
        return null;
    }

    @Override
    public boolean setProfileHdxProp(String docId, String hdx) {
        return false;
    }
}

