/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.docnav.dao;

import com.huawei.support.icscbb.hwics.common.docnav.constant.IcsDocnavConstants;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.mapper.IcsDocnavMapper;
import com.huawei.support.icscbb.hwics.common.docnav.parse.SaxIcsDocnav;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsDocnavDaoHandler
implements IcsDocnavConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsDocnavDaoHandler.class);

    public static IcsDocnavDaoHandler getInstance() {
        return IcsDocnavDaoHandlerHolder.INSTANCE;
    }

    private IcsDocnavDaoHandler() {
    }

    public void createTb(IcsDocnavMapper icsDocnavMapper) {
        try {
            icsDocnavMapper.createTb();
            icsDocnavMapper.createDocNavTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'ICSDOCNAV' already exists or create error.", e);
        }
    }

    public IcsDocnavDo create(InputStream is, List<String> docnaviIdList) throws SAXException {
        SaxIcsDocnav saxParser = new SaxIcsDocnav(docnaviIdList);
        SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
        return saxParser.getIcsDocnav();
    }

    public boolean add(List<IcsDocnavDo> icsDocnavList, IcsDocnavMapper icsDocnavMapper) {
        boolean isAdd = false;
        if (CollectionUtils.isEmpty(icsDocnavList)) {
            return false;
        }
        int listSize = icsDocnavList.size();
        if (listSize < 1000) {
            return this.addIcsDocnavList(icsDocnavList, icsDocnavMapper);
        }
        for (int num = 0; num < listSize; num += 1000) {
            isAdd = num + 1000 < listSize ? this.addIcsDocnavList(icsDocnavList.subList(num, num + 1000), icsDocnavMapper) : this.addIcsDocnavList(icsDocnavList.subList(num, listSize), icsDocnavMapper);
            if (isAdd) continue;
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsDocnavList add fail.");
            break;
        }
        return isAdd;
    }

    private boolean addIcsDocnavList(List<IcsDocnavDo> icsDocnavList, IcsDocnavMapper icsDocnavMapper) {
        try {
            icsDocnavMapper.add(icsDocnavList);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add ERROR", e);
            return false;
        }
        return true;
    }

    public boolean del(String docId, IcsDocnavMapper icsDocnavMapper) {
        try {
            icsDocnavMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del ERROR", e);
            return false;
        }
        return true;
    }

    public boolean delAll(IcsDocnavMapper icsDocnavMapper) {
        try {
            icsDocnavMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delAll ERROR", e);
            return false;
        }
        return true;
    }

    public List<IcsDocnavDo> get(String docId, IcsDocnavMapper icsDocnavMapper) {
        ArrayList<IcsDocnavDo> list = new ArrayList<IcsDocnavDo>();
        try {
            list.addAll(icsDocnavMapper.get(docId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get ERROR", e);
        }
        return list;
    }

    public Set<String> getAllDocId(IcsDocnavMapper icsDocnavMapper) {
        HashSet<String> docidSet = new HashSet<String>();
        try {
            docidSet.addAll(icsDocnavMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsDocnavMapper getAllDocId ERROR", e);
        }
        return docidSet;
    }

    public void updateFilterJson(String docId, String docnavId, String filterJson, IcsDocnavMapper icsDocnavMapper) {
        try {
            icsDocnavMapper.updateFilterJson(docId, docnavId, filterJson);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "updateFilterJson ERROR", e);
        }
    }

    public List<IcsDocnavDo> createFromIcsBaseDo(IcsBaseDo icsBaseDo) {
        ArrayList<IcsDocnavDo> icsDocnavList = new ArrayList<IcsDocnavDo>();
        LinkedList<String> docnaviIdList = new LinkedList<String>();
        for (int num = 0; num < 6; ++num) {
            IcsDocnavDo icsDocnavDo = this.createIcsDocnavDo(icsBaseDo, num, docnaviIdList);
            if (icsDocnavDo == null) continue;
            docnaviIdList.add(icsDocnavDo.getDocnavId());
            icsDocnavList.add(icsDocnavDo);
        }
        return icsDocnavList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IcsDocnavDo createIcsDocnavDo(IcsBaseDo icsBaseDo, int index, List<String> docnaviIdList) {
        IcsDocnavDo icsDocnavDo = null;
        String docNavId = "docnav" + (index == 0 ? "" : Integer.valueOf(index));
        String docnavPath = "resources/infocenter_service/metadata/" + docNavId + ".xml";
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)docnavPath);){
            if (is == null) {
                IcsDocnavDo icsDocnavDo2 = null;
                return icsDocnavDo2;
            }
            icsDocnavDo = this.create(is, docnaviIdList);
            if (icsDocnavDo == null) {
                IcsDocnavDo icsDocnavDo3 = null;
                return icsDocnavDo3;
            }
            if (StringUtils.isEmpty((CharSequence)icsDocnavDo.getDocnavId())) {
                icsDocnavDo.setDocnavId(docNavId);
            }
            icsDocnavDo.setDocnavPath(docnavPath);
            IcsBaseService.setContent((IcsBaseDo)icsDocnavDo, (IcsBaseDo)icsBaseDo);
            return icsDocnavDo;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error", (Throwable)e);
            return icsDocnavDo;
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create SAXException", (Throwable)e);
        }
        return icsDocnavDo;
    }

    private static final class IcsDocnavDaoHandlerHolder {
        private static final IcsDocnavDaoHandler INSTANCE = new IcsDocnavDaoHandler();

        private IcsDocnavDaoHandlerHolder() {
        }
    }
}

