/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.docnav.parse;

import com.huawei.support.icscbb.hwics.common.docnav.constant.IcsDocnavConstants;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxIcsDocnav
extends DefaultHandler
implements IcsDocnavConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SaxIcsDocnav.class);
    private static final int META_INDEX = 5;
    private static final int MAP_SIZE = 16;
    private final Stack<String> qNameStack = new Stack();
    private final IcsDocnavDo icsDocnavDo = new IcsDocnavDo();
    private final List<Map<String, String>> filterList = this.icsDocnavDo.getFilterList();
    private final List<String> docnaviIdList;
    private final List<Map<String, String>> filterRelationsList = this.icsDocnavDo.getFilterRelationsList();

    public SaxIcsDocnav(List<String> docnaviIdList) {
        this.docnaviIdList = docnaviIdList;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "docNav": {
                this.setDocnav(atts);
                break;
            }
            case "filter": {
                this.setFilter(atts);
                break;
            }
            case "filters": 
            case "filterwithrelation": {
                this.setFilterRelation(atts);
                break;
            }
        }
        this.qNameStack.add(qName);
    }

    @Override
    public void endElement(String uri, String name, String eleName) {
        this.qNameStack.pop();
        switch (eleName) {
            default: 
        }
    }

    @Override
    public void endDocument() {
        this.icsDocnavDo.setbUse(true);
    }

    private void setDocnav(Attributes atts) throws SAXException {
        String docnaviId = atts.getValue("id");
        if (this.docnaviIdList.contains(docnaviId)) {
            throw new SAXException("docnaviIdList have same docnaviId :" + docnaviId);
        }
        this.icsDocnavDo.setDocnavId(docnaviId);
        String docnaviName = atts.getValue("type");
        this.icsDocnavDo.setDocnavName(docnaviName);
    }

    private void setFilter(Attributes atts) {
        if ("filters".equals(this.qNameStack.peek())) {
            LinkedHashMap<String, String> filterMap = new LinkedHashMap<String, String>();
            String metanameId = atts.getValue("metanameid");
            filterMap.put("metanameid", metanameId);
            String name = atts.getValue("name");
            filterMap.put("name", name);
            String topicfilter = atts.getValue("topicfilter");
            filterMap.put("topicfilter", topicfilter);
            String nometanamepolicy = atts.getValue("nometanamepolicy");
            filterMap.put("nometanamepolicy", nometanamepolicy);
            String metaValueIdlist = atts.getValue("metavalueidlist");
            if (metanameId == null) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "setTag error. metanameId : null.");
                return;
            }
            filterMap.put("metalist", metaValueIdlist);
            this.filterList.add(filterMap);
        }
    }

    private void setFilterRelation(Attributes atts) {
        if ("filterwithrelations".equals(this.qNameStack.peek())) {
            LinkedHashMap<String, String> filterRelationsMap = new LinkedHashMap<String, String>(16);
            String title = atts.getValue("title");
            filterRelationsMap.put("title", title);
            for (int i = 1; i < 5; ++i) {
                String metaNameId = "metanameid" + i;
                String metaValueIdList = "metavalueidlist" + i;
                String metaNameIdValue = atts.getValue(metaNameId);
                String metaValueIdListValue = atts.getValue(metaValueIdList);
                filterRelationsMap.put(metaNameId, metaNameIdValue);
                filterRelationsMap.put(metaValueIdList, metaValueIdListValue);
            }
            this.filterRelationsList.add(filterRelationsMap);
        }
    }

    public IcsDocnavDo getIcsDocnav() {
        return this.icsDocnavDo;
    }
}

