/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.docnav.service.impl;

import com.huawei.support.icscbb.hwics.common.docnav.dao.IcsDocnavDaoHandler;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.mapper.IcsDocnavMapper;
import com.huawei.support.icscbb.hwics.common.docnav.service.IcsDocnavService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class IcsDocnavPoolServiceHandler
extends BasePool<List<IcsDocnavDo>>
implements IcsDocnavService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsDocnavPoolServiceHandler.class);
    private final IcsDocnavMapper icsDocnavMapper = (IcsDocnavMapper)DbMapperUtils.getMapper(IcsDocnavMapper.class);

    public static IcsDocnavPoolServiceHandler getInstance() {
        return IcsDocnavPoolServiceHandlerHolder.INSTANCE;
    }

    private IcsDocnavPoolServiceHandler() {
    }

    protected void createPool(String key) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "create key" + key);
        List<IcsDocnavDo> icsDocnavList = this.getFromDb(key);
        super.addPool(key, icsDocnavList);
        super.checkPool(5);
    }

    private List<IcsDocnavDo> getFromDb(String docId) {
        ArrayList<IcsDocnavDo> list = new ArrayList<IcsDocnavDo>();
        CodeCCUtils.INSTANCE.debugLog(LOG, "get, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return list;
        }
        list.addAll(IcsDocnavDaoHandler.getInstance().get(docId, this.icsDocnavMapper));
        return list;
    }

    @Override
    public IcsDocnavDo getByDocNavId(String docId, String docnavId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, docnavId})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return null;
        }
        List icsDocnavList = (List)super.getPool(docId);
        return icsDocnavList.stream().filter(icsDocnavDo -> docnavId.equals(icsDocnavDo.getDocnavId())).findFirst().orElse(null);
    }

    @Override
    public String getFilterByDocNaviId(String docId, String docnavId) {
        IcsDocnavDo icsDocnav = this.getByDocNavId(docId, docnavId);
        if (icsDocnav != null) {
            return icsDocnav.getFilterJson();
        }
        return null;
    }

    @Override
    public void createTb() {
        IcsDocnavDaoHandler.getInstance().createTb(this.icsDocnavMapper);
    }

    @Override
    public List<IcsDocnavDo> create(IcsBaseDo icsBaseDo) {
        return IcsDocnavDaoHandler.getInstance().createFromIcsBaseDo(icsBaseDo);
    }

    @Override
    public boolean add(List<IcsDocnavDo> docnavList) {
        return IcsDocnavDaoHandler.getInstance().add(docnavList, this.icsDocnavMapper);
    }

    @Override
    public boolean del(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "del, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return false;
        }
        super.delPool(docId);
        return IcsDocnavDaoHandler.getInstance().del(docId, this.icsDocnavMapper);
    }

    @Override
    public boolean delAll() {
        return IcsDocnavDaoHandler.getInstance().delAll(this.icsDocnavMapper);
    }

    @Override
    public List<IcsDocnavDo> get(String docId) {
        ArrayList<IcsDocnavDo> list = new ArrayList<IcsDocnavDo>();
        CodeCCUtils.INSTANCE.debugLog(LOG, "get, docId: " + docId);
        if (docId == null) {
            return list;
        }
        List newlist = (List)this.getPool(docId);
        if (newlist != null) {
            list.addAll(newlist);
        }
        return list;
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        return new HashSet<String>(IcsDocnavDaoHandler.getInstance().getAllDocId(this.icsDocnavMapper));
    }

    @Override
    public String getFilterRelationByDocNaviId(String docId, String docnavId) {
        IcsDocnavDo icsDocnav = this.getByDocNavId(docId, docnavId);
        return icsDocnav != null ? icsDocnav.getFilterRelationsJson() : null;
    }

    @Override
    public void updateFilterJson(String docId, String docnavId, String filterJson) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, docnavId})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return;
        }
        IcsDocnavDaoHandler.getInstance().updateFilterJson(docId, docnavId, filterJson, this.icsDocnavMapper);
    }

    private static final class IcsDocnavPoolServiceHandlerHolder {
        private static final IcsDocnavPoolServiceHandler INSTANCE = new IcsDocnavPoolServiceHandler();

        private IcsDocnavPoolServiceHandlerHolder() {
        }
    }
}

