/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.docnav.service.impl;

import com.huawei.support.icscbb.hwics.common.docnav.constant.IcsDocnavConstants;
import com.huawei.support.icscbb.hwics.common.docnav.dao.IcsDocnavDao;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.service.IcsDocnavService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;

@Service(value="icsDocnavServiceImpl")
@ComponentScan(basePackages={"com.huawei.support.hwics"})
public class IcsDocnavServiceImpl
implements IcsDocnavService,
IcsDocnavConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsDocnavServiceImpl.class);
    @Resource
    private IcsDocnavDao icsDocnavDao;

    @Override
    public void createTb() {
        this.icsDocnavDao.createTb();
    }

    @Override
    public List<IcsDocnavDo> create(IcsBaseDo icsBaseDo) {
        ArrayList<IcsDocnavDo> icsDocnavList = new ArrayList<IcsDocnavDo>();
        LinkedList<String> docnaviIdList = new LinkedList<String>();
        for (int num = 0; num < 6; ++num) {
            IcsDocnavDo icsDocnavDo = this.createOne(icsBaseDo, num, docnaviIdList);
            if (icsDocnavDo == null) continue;
            docnaviIdList.add(icsDocnavDo.getDocnavId());
            icsDocnavList.add(icsDocnavDo);
        }
        return icsDocnavList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IcsDocnavDo createOne(IcsBaseDo icsBaseDo, int index, List<String> docnaviIdList) {
        IcsDocnavDo icsDocnavDo = null;
        String docNavId = "docnav" + (index == 0 ? "" : Integer.valueOf(index));
        String docnavPath = "resources/infocenter_service/metadata/" + docNavId + ".xml";
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)docnavPath);){
            if (is == null) {
                IcsDocnavDo icsDocnavDo2 = null;
                return icsDocnavDo2;
            }
            icsDocnavDo = this.icsDocnavDao.create(is, docnaviIdList);
            if (icsDocnavDo == null) {
                IcsDocnavDo icsDocnavDo3 = null;
                return icsDocnavDo3;
            }
            String oldDocnavId = icsDocnavDo.getDocnavId();
            if (StringUtils.isEmpty((CharSequence)oldDocnavId)) {
                icsDocnavDo.setDocnavId(docNavId);
            }
            icsDocnavDo.setDocnavPath(docnavPath);
            IcsBaseService.setContent((IcsBaseDo)icsDocnavDo, (IcsBaseDo)icsBaseDo);
            return icsDocnavDo;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error", (Throwable)e);
            return icsDocnavDo;
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return icsDocnavDo;
    }

    @Override
    public boolean add(List<IcsDocnavDo> docnavList) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "add: " + docnavList.size());
        return this.icsDocnavDao.add(docnavList);
    }

    @Override
    public boolean del(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "del, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return false;
        }
        return this.icsDocnavDao.del(docId);
    }

    @Override
    public boolean delAll() {
        return false;
    }

    @Override
    public List<IcsDocnavDo> get(String docId) {
        ArrayList<IcsDocnavDo> list = new ArrayList<IcsDocnavDo>();
        CodeCCUtils.INSTANCE.debugLog(LOG, "get, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return list;
        }
        list.addAll(this.icsDocnavDao.get(docId));
        return list;
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        return new HashSet<String>(this.icsDocnavDao.getAllDocId());
    }

    @Override
    public String getFilterByDocNaviId(String docId, String docnavId) {
        if (docId == null || docnavId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return null;
        }
        IcsDocnavDo icsDocnav = this.getByDocNavId(docId, docnavId);
        if (icsDocnav != null) {
            return icsDocnav.getFilterJson();
        }
        return null;
    }

    @Override
    public IcsDocnavDo getByDocNavId(String docId, String docnavId) {
        if (docId == null || docnavId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return null;
        }
        List<IcsDocnavDo> icsDocnavList = this.get(docId);
        if (icsDocnavList.size() == 0) {
            return null;
        }
        Optional<IcsDocnavDo> icsDocnavOptional = icsDocnavList.stream().filter(item -> item.getDocnavId().equals(docnavId)).findFirst();
        return icsDocnavOptional.orElse(null);
    }

    @Override
    public String getFilterRelationByDocNaviId(String docId, String docnavId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, docnavId})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return null;
        }
        IcsDocnavDo icsDocnav = this.getByDocNavId(docId, docnavId);
        if (icsDocnav != null) {
            return icsDocnav.getFilterRelationsJson();
        }
        return null;
    }

    @Override
    public void updateFilterJson(String docId, String docnavId, String filterJson) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, docnavId})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return;
        }
        this.icsDocnavDao.updateFilterJson(docId, docnavId, filterJson);
    }
}

