/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icspid.dao;

import com.huawei.support.icscbb.hwics.common.icspid.constant.IcsPidConstants;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.mapper.IcsPidMapper;
import com.huawei.support.icscbb.hwics.common.icspid.parse.SaxIcsPid;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsPidDaoHandler
implements IcsPidConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsPidDaoHandler.class);

    private IcsPidDaoHandler() {
    }

    public static IcsPidDaoHandler getInstance() {
        return IcsPidDaoHandlerHolder.INSTANCE;
    }

    public void createTb(IcsPidMapper icsPidMapper) {
        try {
            icsPidMapper.createTb();
            icsPidMapper.createPidTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'ICSPID' already exists or create error.", e);
        }
    }

    public List<IcsPidDo> create(IcsBaseDo icsBaseDo) {
        ArrayList<IcsPidDo> icsPidList = new ArrayList<IcsPidDo>();
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)"resources/infocenter_service/metadata/pid_meta.xml");){
            if (is != null) {
                icsPidList.addAll(this.create(is));
                for (IcsPidDo icsPidDo : icsPidList) {
                    IcsBaseService.setContent((IcsBaseDo)icsPidDo, (IcsBaseDo)icsBaseDo);
                }
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error", (Throwable)e);
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return icsPidList;
    }

    public List<IcsPidDo> create(InputStream inputStream) throws SAXException {
        SaxIcsPid saxParser = new SaxIcsPid();
        SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)saxParser);
        return saxParser.getIcsPidList();
    }

    public boolean add(IcsPidMapper icsPidMapper, List<IcsPidDo> icsPidList) {
        boolean isAdd = false;
        int listSize = icsPidList.size();
        if (listSize < 1000) {
            return this.addIcsPidList(icsPidMapper, icsPidList);
        }
        for (int num = 0; num < listSize; num += 1000) {
            isAdd = num + 1000 < listSize ? this.addIcsPidList(icsPidMapper, icsPidList.subList(num, num + 1000)) : this.addIcsPidList(icsPidMapper, icsPidList.subList(num, listSize));
            if (isAdd) continue;
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsPidList add fail.");
            break;
        }
        return isAdd;
    }

    private boolean addIcsPidList(IcsPidMapper icsPidMapper, List<IcsPidDo> icsPidList) {
        try {
            icsPidMapper.add(icsPidList);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add ERROR", e);
            return false;
        }
        return true;
    }

    public boolean del(IcsPidMapper icsPidMapper, String docId) {
        try {
            icsPidMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del ERROR", e);
            return false;
        }
        return true;
    }

    public boolean delAll(IcsPidMapper icsPidMapper) {
        try {
            icsPidMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "IcsPidMapper delAll ERROR", e);
            return false;
        }
        return true;
    }

    public List<IcsPidDo> get(IcsPidMapper icsPidMapper, String docId) {
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        try {
            list.addAll(icsPidMapper.get(docId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get ERROR", e);
        }
        return list;
    }

    public List<IcsPidDo> getbyMetaName(IcsPidMapper icsPidMapper, String docId, String metaName) {
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        try {
            list.addAll(icsPidMapper.getbyMetaName(docId, "\"" + metaName + "\""));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getbyMetaName ERROR", e);
        }
        return list;
    }

    public List<IcsPidDo> getbyMetaValue(IcsPidMapper icsPidMapper, String docId, String metaValue) {
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        try {
            list.addAll(icsPidMapper.getbyMetaValue(docId, "\"" + metaValue + "\""));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getbyMetaValue ERROR", e);
        }
        return list;
    }

    public List<IcsPidDo> getAll(IcsPidMapper icsPidMapper, String docId, int start, int len) {
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        try {
            list.addAll(icsPidMapper.getAll(docId, start, len));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAll ERROR", e);
        }
        return list;
    }

    public Set<String> getAllDocId(IcsPidMapper icsPidMapper) {
        HashSet<String> docidSet = new HashSet<String>();
        try {
            docidSet.addAll(icsPidMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAllDocId ERROR", e);
        }
        return docidSet;
    }

    private static class IcsPidDaoHandlerHolder {
        private static final IcsPidDaoHandler INSTANCE = new IcsPidDaoHandler();

        private IcsPidDaoHandlerHolder() {
        }
    }
}

