/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icspid.parse;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxIcsPid
extends DefaultHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SaxIcsPid.class);
    private final List<IcsPidDo> icsPidList = new ArrayList<IcsPidDo>();
    private final Stack<String> nodeNameStack = new Stack();
    private IcsPidDo icsPidDo;
    private Map<String, String> propertyMap;
    private Map<String, Set<String>> tagMap;
    private Set<String> tagsMetanameidSet;
    private Set<String> tagsMetavalueidSet;
    private Set<Map<String, String>> relationSet;

    @Override
    public void startElement(String uri, String name, String nodeName, Attributes atts) {
        switch (nodeName) {
            case "pid": {
                this.setPid(atts);
                break;
            }
            case "propertys": {
                this.propertyMap = new LinkedHashMap<String, String>();
                break;
            }
            case "property": {
                this.setProperty(atts);
                break;
            }
            case "tags": {
                this.tagMap = new LinkedHashMap<String, Set<String>>();
                this.tagsMetanameidSet = new LinkedHashSet<String>();
                this.tagsMetavalueidSet = new LinkedHashSet<String>();
                break;
            }
            case "tag": {
                this.setTag(atts);
                break;
            }
            case "relations": {
                this.relationSet = new LinkedHashSet<Map<String, String>>();
                break;
            }
            case "relation": {
                this.setRelation(atts);
                break;
            }
        }
        this.nodeNameStack.add(nodeName);
    }

    @Override
    public void endElement(String uri, String name, String nodeName) {
        this.nodeNameStack.pop();
        switch (nodeName) {
            case "pid": {
                this.setPidEnd();
                break;
            }
            case "propertys": {
                this.setPropertys();
                break;
            }
            case "tags": {
                this.setTags();
                break;
            }
            case "relations": {
                this.setRelations();
                break;
            }
        }
    }

    @Override
    public void endDocument() {
    }

    private void setPid(Attributes atts) {
        if ("pids".equals(this.nodeNameStack.peek())) {
            String pidId = atts.getValue("id");
            if (pidId != null && pidId.length() > 0) {
                this.icsPidDo = new IcsPidDo();
                this.icsPidDo.setPidId(pidId);
                this.icsPidDo.setPidName(atts.getValue("name"));
            } else {
                CodeCCUtils.INSTANCE.errorLog(LOG, "setPid error. pidId: " + pidId);
            }
        }
    }

    private void setProperty(Attributes atts) {
        if ("propertys".equals(this.nodeNameStack.peek())) {
            if (this.icsPidDo != null && this.propertyMap != null) {
                String key = atts.getValue("key");
                String value = atts.getValue("value");
                if (key != null && value != null) {
                    this.propertyMap.put(key, value);
                } else {
                    CodeCCUtils.INSTANCE.errorLog(LOG, "setProperty error. key: " + key + ", value:" + value);
                }
            } else {
                CodeCCUtils.INSTANCE.errorLog(LOG, "setProperty error. icsPidDo: " + (Object)((Object)this.icsPidDo) + ", propertyMap:" + this.propertyMap);
            }
        }
    }

    private void setTag(Attributes atts) {
        if ("tags".equals(this.nodeNameStack.peek())) {
            if (this.icsPidDo != null && this.tagMap != null) {
                String metanameid = atts.getValue("metanameid");
                String valueid = atts.getValue("valueid");
                if (metanameid != null && valueid != null) {
                    this.setTagAttrs(metanameid, valueid);
                } else {
                    CodeCCUtils.INSTANCE.errorLog(LOG, "setTag error. key: " + metanameid + ", value:" + valueid);
                }
            } else {
                CodeCCUtils.INSTANCE.errorLog(LOG, "setTag error. icsPidDo: " + (Object)((Object)this.icsPidDo) + ", tagMap:" + this.tagMap);
            }
        }
    }

    private void setRelation(Attributes atts) {
        if ("relations".equals(this.nodeNameStack.peek())) {
            if (this.icsPidDo != null && this.relationSet != null) {
                LinkedHashMap<String, String> relationAttsMap = new LinkedHashMap<String, String>();
                String value = atts.getValue("pid_id");
                relationAttsMap.put("pid_id", value);
                value = atts.getValue("projectid");
                relationAttsMap.put("projectid", value);
                value = atts.getValue("url");
                relationAttsMap.put("url", value);
                value = atts.getValue("name");
                relationAttsMap.put("name", value);
                this.relationSet.add(relationAttsMap);
            } else {
                CodeCCUtils.INSTANCE.errorLog(LOG, "setTag error. icsPidDo: " + (Object)((Object)this.icsPidDo) + ", relationList:" + this.relationSet);
            }
        }
    }

    private void setPidEnd() {
        if ("pids".equals(this.nodeNameStack.peek()) && this.icsPidDo != null) {
            this.icsPidDo.setbUse(true);
            this.icsPidList.add(this.icsPidDo);
            this.icsPidDo = null;
        }
    }

    private void setPropertys() {
        if (this.icsPidDo != null && this.propertyMap != null) {
            String propertysJson = JSON.toJSONString(this.propertyMap);
            this.icsPidDo.setPropertysJson(propertysJson);
            this.propertyMap = null;
        }
    }

    private void setTags() {
        if (this.icsPidDo != null) {
            if (this.tagMap != null) {
                String tagsJson = JSON.toJSONString(this.tagMap);
                this.icsPidDo.setTagsJson(tagsJson);
                this.tagMap = null;
            }
            if (this.tagsMetanameidSet != null) {
                String tagsMetanameid = JSON.toJSONString(this.tagsMetanameidSet);
                this.icsPidDo.setTagsMetanameid(tagsMetanameid);
                this.tagsMetanameidSet = null;
            }
            if (this.tagsMetavalueidSet != null) {
                String tagsValueid = JSON.toJSONString(this.tagsMetavalueidSet);
                this.icsPidDo.setTagsValueid(tagsValueid);
                this.tagsMetavalueidSet = null;
            }
        }
    }

    private void setRelations() {
        if (this.icsPidDo != null && this.relationSet != null) {
            String relationsJson = JSON.toJSONString(this.relationSet);
            this.icsPidDo.setRelationsJson(relationsJson);
            this.relationSet = null;
        }
    }

    public List<IcsPidDo> getIcsPidList() {
        return this.icsPidList;
    }

    private void setTagAttrs(String metanameid, String valueid) {
        Set valueidSet = this.tagMap.computeIfAbsent(metanameid, value -> new LinkedHashSet());
        if (valueidSet != null) {
            valueidSet.add(valueid);
        }
        this.tagsMetanameidSet.add(metanameid);
        this.tagsMetavalueidSet.add(valueid);
    }
}

