/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icspid.service.impl;

import com.huawei.support.icscbb.hwics.common.icspid.dao.IcsPidDaoHandler;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.mapper.IcsPidMapper;
import com.huawei.support.icscbb.hwics.common.icspid.service.IcsPidService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class IcsPidPoolServiceHandler
extends BasePool<List<IcsPidDo>>
implements IcsPidService {
    private static final IcsPidMapper ICS_PID_MAPPER = (IcsPidMapper)DbMapperUtils.getMapper(IcsPidMapper.class);
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsPidPoolServiceHandler.class);
    private static final int MIN_INDEX = 10;
    private static final int MAX_INDEX = 100;

    private IcsPidPoolServiceHandler() {
    }

    public static IcsPidPoolServiceHandler getInstance() {
        return IcsPidPoolServiceImplHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "get, key: " + key);
        ArrayList<IcsPidDo> icsPidList = new ArrayList<IcsPidDo>();
        if (key == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "key is null.");
        } else {
            icsPidList.addAll(IcsPidDaoHandler.getInstance().get(ICS_PID_MAPPER, key));
        }
        if (icsPidList != null) {
            super.addPool(key, icsPidList);
            super.checkPool(100);
        }
    }

    public List<IcsPidDo> getPool(String key) {
        List icsPidList = (List)super.getPool(key);
        if (icsPidList != null) {
            return icsPidList;
        }
        return new ArrayList<IcsPidDo>(0);
    }

    @Override
    public void createTb() {
        IcsPidDaoHandler.getInstance().createTb(ICS_PID_MAPPER);
    }

    @Override
    public List<IcsPidDo> create(IcsBaseDo icsBaseDo) {
        return IcsPidDaoHandler.getInstance().create(icsBaseDo);
    }

    @Override
    public boolean add(List<IcsPidDo> icsPidList) {
        return IcsPidDaoHandler.getInstance().add(ICS_PID_MAPPER, icsPidList);
    }

    @Override
    public boolean del(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "del, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return false;
        }
        super.delPool(docId);
        return IcsPidDaoHandler.getInstance().del(ICS_PID_MAPPER, docId);
    }

    @Override
    public boolean delAll() {
        return IcsPidDaoHandler.getInstance().delAll(ICS_PID_MAPPER);
    }

    @Override
    public List<IcsPidDo> get(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "get, docId: " + docId);
        if (docId == null) {
            return null;
        }
        return this.getPool(docId);
    }

    @Override
    public IcsPidDo getOne(String docId, String pidId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getOne, docId: " + docId + " pidId:" + pidId);
        if (docId == null || pidId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or pidId is null.");
            return null;
        }
        ArrayList list = new ArrayList(this.getPool(docId));
        for (IcsPidDo icsPidDo : list) {
            if (!pidId.equals(icsPidDo.getPidId())) continue;
            return icsPidDo;
        }
        return null;
    }

    @Override
    public List<IcsPidDo> getbyMetaName(String docId, String metaName) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getbyMetaName, docId: " + docId + " metaName:" + metaName);
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return null;
        }
        if (metaName == null) {
            list.addAll(this.get(docId));
        } else {
            list.addAll(IcsPidDaoHandler.getInstance().getbyMetaName(ICS_PID_MAPPER, docId, metaName));
        }
        return list;
    }

    @Override
    public List<IcsPidDo> getbyMetaValue(String docId, String metaValue) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getbyMetaValue, docId: " + docId + " metaValue:" + metaValue);
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return null;
        }
        if (metaValue == null) {
            list.addAll(this.get(docId));
        } else {
            list.addAll(IcsPidDaoHandler.getInstance().getbyMetaValue(ICS_PID_MAPPER, docId, metaValue));
        }
        return list;
    }

    @Override
    public List<IcsPidDo> getAll(String docId, int start, int len) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAll, start: " + start + " len:" + len);
        int myStart = Math.max(start, 0);
        int myLen = len <= 0 ? 10 : len;
        myLen = myLen > 100 ? 10 : myLen;
        return IcsPidDaoHandler.getInstance().getAll(ICS_PID_MAPPER, docId, myStart, myLen);
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        return IcsPidDaoHandler.getInstance().getAllDocId(ICS_PID_MAPPER);
    }

    private static class IcsPidPoolServiceImplHandlerHolder {
        private static final IcsPidPoolServiceHandler INSTANCE = new IcsPidPoolServiceHandler();

        private IcsPidPoolServiceImplHandlerHolder() {
        }
    }
}

