/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icspid.service.impl;

import com.huawei.support.icscbb.hwics.common.icspid.dao.IcsPidDao;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.service.IcsPidService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;

@Service(value="icsPidServiceImpl")
@ComponentScan(basePackages={"com.huawei.support.hwics"})
public class IcsPidServiceImpl
implements IcsPidService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsPidServiceImpl.class);
    private static final int MIN_INDEX = 10;
    private static final int MAX_INDEX = 100;
    @Resource
    private IcsPidDao icsPidDao;

    @Override
    public void createTb() {
        this.icsPidDao.createTb();
    }

    @Override
    public List<IcsPidDo> create(IcsBaseDo icsBaseDo) {
        ArrayList<IcsPidDo> icsPidList = new ArrayList<IcsPidDo>();
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)"resources/infocenter_service/metadata/pid_meta.xml");){
            if (is != null) {
                icsPidList.addAll(this.icsPidDao.create(is));
                for (IcsPidDo icsPidDo : icsPidList) {
                    IcsBaseService.setContent((IcsBaseDo)icsPidDo, (IcsBaseDo)icsBaseDo);
                }
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error", (Throwable)e);
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return icsPidList;
    }

    @Override
    public boolean add(List<IcsPidDo> icsPidList) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "add: " + icsPidList.size());
        return this.icsPidDao.add(icsPidList);
    }

    @Override
    public boolean del(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "del, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return false;
        }
        return this.icsPidDao.del(docId);
    }

    @Override
    public boolean delAll() {
        return false;
    }

    @Override
    public List<IcsPidDo> get(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "get, docId: " + docId);
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return list;
        }
        list.addAll(this.icsPidDao.get(docId));
        return list;
    }

    @Override
    public IcsPidDo getOne(String docId, String pidId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getOne, docId: " + docId + " pidId:" + pidId);
        if (docId == null || pidId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or pidId is empty.");
            return null;
        }
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>(this.icsPidDao.get(docId));
        for (IcsPidDo icsPidDo : list) {
            if (!pidId.equals(icsPidDo.getPidId())) continue;
            return icsPidDo;
        }
        return null;
    }

    @Override
    public List<IcsPidDo> getbyMetaName(String docId, String metaName) {
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        CodeCCUtils.INSTANCE.debugLog(LOG, "getbyMetaName, docId: " + docId + " metaName:" + metaName);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return list;
        }
        if (metaName == null) {
            list.addAll(this.get(docId));
        } else {
            list.addAll(this.icsPidDao.getbyMetaName(docId, metaName));
        }
        return list;
    }

    @Override
    public List<IcsPidDo> getbyMetaValue(String docId, String metaValue) {
        ArrayList<IcsPidDo> list = new ArrayList<IcsPidDo>();
        CodeCCUtils.INSTANCE.debugLog(LOG, "getbyMetaValue, docId: " + docId + " metaValue:" + metaValue);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return list;
        }
        if (metaValue == null) {
            list.addAll(this.get(docId));
        } else {
            list.addAll(this.icsPidDao.getbyMetaValue(docId, metaValue));
        }
        return list;
    }

    @Override
    public List<IcsPidDo> getAll(String docId, int start, int len) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAll, start: " + start + " len:" + len);
        int myStart = Math.max(start, 0);
        int myLen = len <= 0 ? 10 : len;
        myLen = myLen > 100 ? 10 : myLen;
        return this.icsPidDao.getAll(docId, myStart, myLen);
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        return new HashSet<String>(this.icsPidDao.getAllDocId());
    }
}

