/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icsversionrelation.dao;

import com.huawei.support.icscbb.hwics.common.icsversionrelation.constant.IcsVersionRelationConstants;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsVersionRelationGroupDaoHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.mapper.IcsVersionRelationGroupMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class IcsRelationDocIdPoolServiceHandler
extends BasePool<List<String>>
implements IcsVersionRelationConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsRelationDocIdPoolServiceHandler.class);
    private static final IcsVersionRelationGroupMapper ICS_VERSION_RELATION_GROUP_MAPPER = (IcsVersionRelationGroupMapper)DbMapperUtils.getMapper(IcsVersionRelationGroupMapper.class);

    private IcsRelationDocIdPoolServiceHandler() {
    }

    public static IcsRelationDocIdPoolServiceHandler getInstance() {
        return IcsRelationDocIdPoolServiceImplHandlerHolder.INSTANCE;
    }

    public void createPool(String key) {
        ArrayList<String> docIdList = new ArrayList<String>(IcsVersionRelationGroupDaoHandler.getInstance().getDocidList(ICS_VERSION_RELATION_GROUP_MAPPER, key));
        super.addPool(key, docIdList);
        super.checkPool(5);
    }

    public List<String> delPool(String key) {
        CodeCCUtils.INSTANCE.infoLog(LOG, "delPool, key: {0}", new Object[]{key});
        return (List)super.delPool(key);
    }

    public List<String> getPool(String key) {
        CodeCCUtils.INSTANCE.infoLog(LOG, "getPool, key: {0}", new Object[]{key});
        ArrayList<String> docIdList = new ArrayList<String>();
        List docIdPoolList = (List)super.getPool(key);
        if (CollectionUtils.isNotEmpty((Collection)docIdPoolList)) {
            docIdList.addAll(docIdPoolList);
        }
        return docIdList;
    }

    private static class IcsRelationDocIdPoolServiceImplHandlerHolder {
        private static final IcsRelationDocIdPoolServiceHandler INSTANCE = new IcsRelationDocIdPoolServiceHandler();

        private IcsRelationDocIdPoolServiceImplHandlerHolder() {
        }
    }
}

