/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icsversionrelation.dao;

import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsRelationDocIdPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsVersionRelationGroupDaoHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsVersionRelationProductDaoHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dto.IcsVersionRelationGroupDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dto.IcsVersionRelationProductDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.mapper.IcsVersionRelationGroupMapper;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.mapper.IcsVersionRelationProductMapper;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.parse.SaxIcsVersionRelation;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsVersionRelationDaoHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsVersionRelationDaoHandler.class);

    private IcsVersionRelationDaoHandler() {
    }

    public static IcsVersionRelationDaoHandler getInstance() {
        return IcsVersionRelationDaoHandlerHolder.INSTANCE;
    }

    public boolean add(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, IcsVersionRelationProductMapper icsVersionRelationProductMapper, IcsBaseDo icsBaseDo) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "add: " + icsBaseDo.getDocId());
        boolean isAddGroup = true;
        boolean isAddProduct = true;
        SaxIcsVersionRelation saxIcsVersionRelation = this.create(icsBaseDo);
        List<IcsVersionRelationGroupDo> relationGroupDoList = saxIcsVersionRelation.getVersionRelationGroup();
        List<IcsVersionRelationProductDo> relationProductDoList = saxIcsVersionRelation.getVersionRelationProduct();
        if (CollectionUtils.isNotEmpty(relationGroupDoList)) {
            this.createGroupDo(relationGroupDoList, icsBaseDo);
            isAddGroup = IcsVersionRelationGroupDaoHandler.getInstance().add(icsVersionRelationGroupMapper, relationGroupDoList);
        }
        if (CollectionUtils.isNotEmpty(relationProductDoList)) {
            this.createProductDo(relationProductDoList, icsBaseDo);
            isAddProduct = IcsVersionRelationProductDaoHandler.getInstance().add(icsVersionRelationProductMapper, relationProductDoList);
        }
        if (isAddGroup && isAddProduct) {
            return true;
        }
        CodeCCUtils.INSTANCE.errorLog(LOG, "icsVersionRelationGroupDoList or icsVersionRelationProductDoList add fail.");
        return false;
    }

    private void createGroupDo(List<IcsVersionRelationGroupDo> icsVersionRelationGroupDoList, IcsBaseDo icsBaseDo) {
        for (IcsVersionRelationGroupDo icsVersionRelationGroupDo : icsVersionRelationGroupDoList) {
            IcsBaseService.setContent((IcsBaseDo)icsVersionRelationGroupDo, (IcsBaseDo)icsBaseDo);
        }
    }

    private void createProductDo(List<IcsVersionRelationProductDo> icsVersionRelationProductDoList, IcsBaseDo icsBaseDo) {
        for (IcsVersionRelationProductDo icsVersionRelationProductDo : icsVersionRelationProductDoList) {
            IcsBaseService.setContent((IcsBaseDo)icsVersionRelationProductDo, (IcsBaseDo)icsBaseDo);
        }
    }

    private SaxIcsVersionRelation create(IcsBaseDo icsBaseDo) {
        SaxIcsVersionRelation saxIcsVersionRelation = new SaxIcsVersionRelation();
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)"resources/infocenter_service/metadata/versionrelation.xml");){
            if (is != null) {
                saxIcsVersionRelation = this.create(is);
            } else {
                CodeCCUtils.INSTANCE.debugLog(LOG, "icsVersionRelationGroupDtos is null");
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error");
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return saxIcsVersionRelation;
    }

    private SaxIcsVersionRelation create(InputStream inputStream) throws SAXException {
        SaxIcsVersionRelation saxIcsVersionRelation = new SaxIcsVersionRelation();
        SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)saxIcsVersionRelation);
        return saxIcsVersionRelation;
    }

    public boolean del(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, IcsVersionRelationProductMapper icsVersionRelationProductMapper, String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "del, docId: " + docId);
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del , docId is empty");
            return false;
        }
        IcsRelationDocIdPoolServiceHandler.getInstance().delPool(docId);
        boolean delGroupFlag = IcsVersionRelationGroupDaoHandler.getInstance().del(icsVersionRelationGroupMapper, docId);
        boolean delProductFlag = IcsVersionRelationProductDaoHandler.getInstance().del(icsVersionRelationProductMapper, docId);
        return delGroupFlag && delProductFlag;
    }

    private static class IcsVersionRelationDaoHandlerHolder {
        private static final IcsVersionRelationDaoHandler INSTANCE = new IcsVersionRelationDaoHandler();

        private IcsVersionRelationDaoHandlerHolder() {
        }
    }
}

