/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icsversionrelation.dao;

import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.constant.IcsVersionRelationConstants;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dto.IcsVersionRelationGroupDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.mapper.IcsVersionRelationGroupMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

public class IcsVersionRelationGroupDaoHandler
implements IcsVersionRelationConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsVersionRelationGroupDaoHandler.class);

    private IcsVersionRelationGroupDaoHandler() {
    }

    public static IcsVersionRelationGroupDaoHandler getInstance() {
        return IcsVersionRelationGroupDaoHandlerHolder.INSTANCE;
    }

    public void createTb(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper) {
        try {
            icsVersionRelationGroupMapper.createTb();
            icsVersionRelationGroupMapper.createRelationGroupTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'ICSVERSIONRELATIONGROUP' already exists or create error.", e);
        }
    }

    public boolean add(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, List<IcsVersionRelationGroupDo> icsVersionRelationGroupDos) {
        boolean isAdd = false;
        int listSize = icsVersionRelationGroupDos.size();
        if (listSize < 1000) {
            return this.addIcsVersionRelationGroupDos(icsVersionRelationGroupMapper, icsVersionRelationGroupDos);
        }
        int num = 0;
        if (num < listSize) {
            isAdd = num + 1000 < listSize ? this.addIcsVersionRelationGroupDos(icsVersionRelationGroupMapper, icsVersionRelationGroupDos.subList(num, num + 1000)) : this.addIcsVersionRelationGroupDos(icsVersionRelationGroupMapper, icsVersionRelationGroupDos.subList(num, listSize));
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsVersionRelationGroupDos add fail.");
        }
        return isAdd;
    }

    private boolean addIcsVersionRelationGroupDos(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, List<IcsVersionRelationGroupDo> icsVersionRelationGroupDos) {
        try {
            icsVersionRelationGroupMapper.add(icsVersionRelationGroupDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add ERROR", e);
            return false;
        }
        return true;
    }

    public boolean del(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, String docId) {
        try {
            icsVersionRelationGroupMapper.del(docId);
            icsVersionRelationGroupMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del ERROR", e);
            return false;
        }
        return true;
    }

    public boolean delAll(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper) {
        try {
            icsVersionRelationGroupMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "IcsVersionRelationGroupMapper delAll ERROR", e);
            return false;
        }
        return true;
    }

    public List<IcsVersionRelationGroupDo> get(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, String docId) {
        ArrayList<IcsVersionRelationGroupDo> list = new ArrayList<IcsVersionRelationGroupDo>();
        try {
            list.addAll(icsVersionRelationGroupMapper.get(docId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get ERROR", e);
        }
        return list;
    }

    public Set<String> getAllDocId(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper) {
        HashSet<String> docidSet = new HashSet<String>();
        try {
            docidSet.addAll(icsVersionRelationGroupMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAllDocId ERROR", e);
        }
        return docidSet;
    }

    public Set<String> getByDocIdProjectidAndVer(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, String relationProjectid, String version, String lang) {
        HashSet<String> list = new HashSet<String>();
        try {
            list.addAll(icsVersionRelationGroupMapper.getByDocIdProjectidAndVer(relationProjectid, version, lang));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByDocIdProjectidAndVer ERROR", e);
        }
        return list;
    }

    public List<IcsVersionRelationGroupDo> getListByProjectIdAndLang(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, String projectId, String language) {
        ArrayList<IcsVersionRelationGroupDo> list = new ArrayList<IcsVersionRelationGroupDo>();
        try {
            list.addAll(icsVersionRelationGroupMapper.getListByProjectIdAndLang(projectId, language));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getVersionRelationsByProjectId ERROR", e);
        }
        return list;
    }

    public Set<String> getDocidList(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, String docId) {
        ArrayList<IcsVersionRelationGroupDo> icsVersionRelationGroupDoList = new ArrayList<IcsVersionRelationGroupDo>();
        ArrayList<IcsContentDo> icsContentDtos = new ArrayList<IcsContentDo>();
        icsVersionRelationGroupDoList.addAll(this.get(icsVersionRelationGroupMapper, docId));
        HashSet<String> docidSet = new HashSet<String>();
        for (IcsVersionRelationGroupDo icsVersionRelationGroupDo : icsVersionRelationGroupDoList) {
            icsContentDtos.addAll(IcsContentPoolServiceHandler.getInstance().getByProjectidAndVer(icsVersionRelationGroupDo.getRelationProjectid(), icsVersionRelationGroupDo.getVersion(), icsVersionRelationGroupDo.getLang()));
            if (!icsContentDtos.isEmpty()) {
                IcsVersionRelationGroupDaoHandler.sort(icsContentDtos);
                docidSet.add(((IcsContentDo)((Object)icsContentDtos.get(0))).getDocId());
            }
            icsContentDtos.clear();
        }
        docidSet.removeIf(set -> set.contains(docId));
        return docidSet;
    }

    public static void sort(List<IcsContentDo> icsContentDtos) {
        Collections.sort(icsContentDtos, new Comparator<IcsContentDo>(){

            @Override
            public int compare(IcsContentDo o1, IcsContentDo o2) {
                String libVersionOne = o1.getLibV();
                String libVersionTwo = o2.getLibV();
                return IcsVersionRelationGroupDaoHandler.sortByLibraryVersion(libVersionOne, libVersionTwo);
            }
        });
    }

    private static int sortByLibraryVersion(String libVersionOne, String libVersionTwo) {
        String libVersionOneTemp = libVersionOne;
        String libVersionTwoTemp = libVersionTwo;
        if (StringUtils.isBlank((CharSequence)libVersionOne)) {
            libVersionOneTemp = "Draft A";
        }
        if (StringUtils.isBlank((CharSequence)libVersionTwo)) {
            libVersionTwoTemp = "Draft A";
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)libVersionTwoTemp, (CharSequence)"Draft") && !StringUtils.startsWithIgnoreCase((CharSequence)libVersionOneTemp, (CharSequence)"Draft")) {
            return -1;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)libVersionOneTemp, (CharSequence)"Draft") && !StringUtils.startsWithIgnoreCase((CharSequence)libVersionTwoTemp, (CharSequence)"Draft")) {
            return 1;
        }
        return libVersionTwoTemp.compareToIgnoreCase(libVersionOneTemp);
    }

    public Set<String> getMainDocIdList(IcsVersionRelationGroupMapper icsVersionRelationGroupMapper, String docId) {
        if (docId == null) {
            return null;
        }
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (icsContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsContentDo  is null");
            return null;
        }
        String projectId = icsContentDo.getProjectid();
        String lang = icsContentDo.getLang();
        String version = icsContentDo.getProductV();
        return this.getByDocIdProjectidAndVer(icsVersionRelationGroupMapper, projectId, version, lang);
    }

    private static class IcsVersionRelationGroupDaoHandlerHolder {
        private static final IcsVersionRelationGroupDaoHandler INSTANCE = new IcsVersionRelationGroupDaoHandler();

        private IcsVersionRelationGroupDaoHandlerHolder() {
        }
    }
}

