/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icsversionrelation.dao;

import com.huawei.support.icscbb.hwics.common.icsversionrelation.constant.IcsVersionRelationConstants;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dto.IcsVersionRelationProductDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.mapper.IcsVersionRelationProductMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

public class IcsVersionRelationProductDaoHandler
implements IcsVersionRelationConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsVersionRelationProductDaoHandler.class);

    private IcsVersionRelationProductDaoHandler() {
    }

    public static IcsVersionRelationProductDaoHandler getInstance() {
        return IcsVersionRelationProductDaoHandlerHolder.INSTANCE;
    }

    public void createTb(IcsVersionRelationProductMapper icsVersionRelationProductMapper) {
        try {
            icsVersionRelationProductMapper.createTb();
            icsVersionRelationProductMapper.createRelationProductTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'ICSVERSIONRELATIONPRODUCT' already exists or create error.", e);
        }
    }

    public boolean add(IcsVersionRelationProductMapper icsVersionRelationProductMapper, List<IcsVersionRelationProductDo> icsVersionRelationProductDos) {
        boolean isAdd = false;
        int listSize = icsVersionRelationProductDos.size();
        if (listSize < 1000) {
            return this.addIcsVersionRelationProductDos(icsVersionRelationProductMapper, icsVersionRelationProductDos);
        }
        int num = 0;
        if (num < listSize) {
            isAdd = num + 1000 < listSize ? this.addIcsVersionRelationProductDos(icsVersionRelationProductMapper, icsVersionRelationProductDos.subList(num, num + 1000)) : this.addIcsVersionRelationProductDos(icsVersionRelationProductMapper, icsVersionRelationProductDos.subList(num, listSize));
            CodeCCUtils.INSTANCE.errorLog(LOG, "addIcsVersionRelationProductDos add fail.");
        }
        return isAdd;
    }

    private boolean addIcsVersionRelationProductDos(IcsVersionRelationProductMapper icsVersionRelationProductMapper, List<IcsVersionRelationProductDo> icsVersionRelationProductDos) {
        try {
            icsVersionRelationProductMapper.add(icsVersionRelationProductDos);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add ERROR", e);
            return false;
        }
        return true;
    }

    public boolean del(IcsVersionRelationProductMapper icsVersionRelationProductMapper, String docId) {
        try {
            icsVersionRelationProductMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del ERROR", e);
            return false;
        }
        return true;
    }

    public boolean delAll(IcsVersionRelationProductMapper icsVersionRelationProductMapper) {
        try {
            icsVersionRelationProductMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "IcsVersionRelationProductMapper delAll ERROR", e);
            return false;
        }
        return true;
    }

    public List<IcsVersionRelationProductDo> get(IcsVersionRelationProductMapper icsVersionRelationProductMapper, String docId) {
        ArrayList<IcsVersionRelationProductDo> list = new ArrayList<IcsVersionRelationProductDo>();
        try {
            list.addAll(icsVersionRelationProductMapper.get(docId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get ERROR", e);
        }
        return list;
    }

    private static class IcsVersionRelationProductDaoHandlerHolder {
        private static final IcsVersionRelationProductDaoHandler INSTANCE = new IcsVersionRelationProductDaoHandler();

        private IcsVersionRelationProductDaoHandlerHolder() {
        }
    }
}

