/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl;

import com.huawei.support.icscbb.hwics.common.icsversionrelation.constant.IcsVersionRelationConstants;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsVersionRelationGroupDao;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dto.IcsVersionRelationGroupDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.IcsVersionRelationGroupService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Service;

@Service
@ComponentScan(basePackages={"com.huawei.support.hwics"})
public class IcsVersionRelationGroupServiceImpl
implements IcsVersionRelationGroupService,
IcsVersionRelationConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsVersionRelationGroupServiceImpl.class);
    @Autowired
    private IcsVersionRelationGroupDao icsVersionRelationGroupDao;

    @Override
    public void createTb() {
        this.icsVersionRelationGroupDao.createTb();
    }

    @Override
    public void create(List<IcsVersionRelationGroupDo> icsVersionRelationGroupDoList, IcsBaseDo icsBaseDo) {
        for (IcsVersionRelationGroupDo icsVersionRelationGroupDo : icsVersionRelationGroupDoList) {
            IcsBaseService.setContent((IcsBaseDo)icsVersionRelationGroupDo, (IcsBaseDo)icsBaseDo);
        }
    }

    @Override
    public boolean add(List<IcsVersionRelationGroupDo> icsVersionRelationGroupDoList, IcsBaseDo icsBaseDo) {
        this.create(icsVersionRelationGroupDoList, icsBaseDo);
        return this.icsVersionRelationGroupDao.add(icsVersionRelationGroupDoList);
    }

    @Override
    public boolean del(String docId) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del , docId is empty");
            return false;
        }
        return this.icsVersionRelationGroupDao.del(docId);
    }

    @Override
    public List<String> getRelationDocIcList(String docId) {
        ArrayList<String> docIdList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getRelationDocIcList , docId is empty");
            return docIdList;
        }
        docIdList.addAll(this.icsVersionRelationGroupDao.getDocidList(docId));
        return docIdList;
    }

    @Override
    public String getMainDocId(String docId) {
        String mainDocId = null;
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getMainDocId , docId is empty");
            return mainDocId;
        }
        List<IcsVersionRelationGroupDo> icsVersionRelationGroupDos = this.icsVersionRelationGroupDao.get(docId);
        if (CollectionUtils.isNotEmpty(icsVersionRelationGroupDos)) {
            mainDocId = docId;
        }
        return mainDocId;
    }

    @Override
    public Set<String> getAllDocId() {
        HashSet<String> docidSet = new HashSet<String>();
        docidSet.addAll(this.icsVersionRelationGroupDao.getAllDocId());
        return docidSet;
    }

    @Override
    public List<String> getDocIdByProjectidAndVer(String relationProjectid, String version, String language) {
        ArrayList<String> docIdList = new ArrayList<String>();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{version, relationProjectid, language})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getDocIdByProjectidAndVer , version or relationProjectid  or language is empty");
            return docIdList;
        }
        docIdList.addAll(this.icsVersionRelationGroupDao.getByDocIdProjectidAndVer(relationProjectid, version, language));
        return docIdList;
    }

    @Override
    public List<IcsVersionRelationGroupDo> getVersionRelationsByDocId(String docId) {
        ArrayList<IcsVersionRelationGroupDo> icsVersionRelationGroupDos = new ArrayList<IcsVersionRelationGroupDo>();
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get VersionRelationGroup list failed, docId is null");
            return icsVersionRelationGroupDos;
        }
        icsVersionRelationGroupDos.addAll(this.icsVersionRelationGroupDao.get(docId));
        if (CollectionUtils.isEmpty(icsVersionRelationGroupDos)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get VersionRelationGroup list failed, docId{0}", new Object[]{docId});
            return icsVersionRelationGroupDos;
        }
        return icsVersionRelationGroupDos;
    }

    @Override
    public List<IcsVersionRelationGroupDo> getListByProjectIdAndLang(String projectId, String language) {
        ArrayList<IcsVersionRelationGroupDo> retRelations = new ArrayList<IcsVersionRelationGroupDo>();
        if (StringUtils.isBlank((CharSequence)projectId) || StringUtils.isBlank((CharSequence)language)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get VersionRelationGroup list failed, projectId or language is null");
            return retRelations;
        }
        retRelations.addAll(this.icsVersionRelationGroupDao.getListByProjectIdAndLang(projectId, language));
        if (CollectionUtils.isEmpty(retRelations)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get VersionRelationGroup list failed, projectId{0},lang{1}", new Object[]{projectId, language});
            return retRelations;
        }
        return retRelations;
    }

    @Override
    public List<String> getMainDocIdList(String docId) {
        ArrayList<String> docIdList = new ArrayList<String>();
        Set<String> list = null;
        list = this.icsVersionRelationGroupDao.getMainDocIdList(docId);
        if (CollectionUtils.isNotEmpty(list)) {
            docIdList.addAll(list);
        }
        return docIdList;
    }
}

