/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl;

import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsRelationDocIdPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsVersionRelationDaoHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsVersionRelationGroupDaoHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dao.IcsVersionRelationProductDaoHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.dto.IcsVersionRelationGroupDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.mapper.IcsVersionRelationGroupMapper;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.mapper.IcsVersionRelationProductMapper;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.IcsVersionRelationService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsVersionRelationPoolServiceHandler
implements IcsVersionRelationService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsVersionRelationPoolServiceHandler.class);
    private static final IcsVersionRelationGroupMapper ICS_VERSION_RELATION_GROUP_MAPPER = (IcsVersionRelationGroupMapper)DbMapperUtils.getMapper(IcsVersionRelationGroupMapper.class);
    private static final IcsVersionRelationProductMapper ICS_VERSION_RELATION_PRODUCT_MAPPER = (IcsVersionRelationProductMapper)DbMapperUtils.getMapper(IcsVersionRelationProductMapper.class);

    private IcsVersionRelationPoolServiceHandler() {
    }

    public static IcsVersionRelationPoolServiceHandler getInstance() {
        return IcsVersionRelationPoolServiceHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "createTb");
        IcsVersionRelationGroupDaoHandler.getInstance().createTb(ICS_VERSION_RELATION_GROUP_MAPPER);
        IcsVersionRelationProductDaoHandler.getInstance().createTb(ICS_VERSION_RELATION_PRODUCT_MAPPER);
    }

    @Override
    public boolean add(IcsBaseDo icsBaseDo) {
        return IcsVersionRelationDaoHandler.getInstance().add(ICS_VERSION_RELATION_GROUP_MAPPER, ICS_VERSION_RELATION_PRODUCT_MAPPER, icsBaseDo);
    }

    @Override
    public boolean del(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "del, docId: " + docId);
        IcsRelationDocIdPoolServiceHandler.getInstance().delPool(docId);
        return IcsVersionRelationDaoHandler.getInstance().del(ICS_VERSION_RELATION_GROUP_MAPPER, ICS_VERSION_RELATION_PRODUCT_MAPPER, docId);
    }

    @Override
    public boolean delAllGroup() {
        return IcsVersionRelationGroupDaoHandler.getInstance().delAll(ICS_VERSION_RELATION_GROUP_MAPPER);
    }

    @Override
    public boolean delAllProduct() {
        return IcsVersionRelationProductDaoHandler.getInstance().delAll(ICS_VERSION_RELATION_PRODUCT_MAPPER);
    }

    @Override
    public List<String> getRelationDocIcList(String docId) {
        ArrayList<String> docIdList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getRelationDocIcList , docId is empty");
            return docIdList;
        }
        docIdList.addAll(IcsVersionRelationGroupDaoHandler.getInstance().getDocidList(ICS_VERSION_RELATION_GROUP_MAPPER, docId));
        return docIdList;
    }

    @Override
    public String getMainDocId(String docId) {
        String mainDocId = null;
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getMainDocId , docId is empty");
            return mainDocId;
        }
        List<IcsVersionRelationGroupDo> icsVersionRelationGroupDos = IcsVersionRelationGroupDaoHandler.getInstance().get(ICS_VERSION_RELATION_GROUP_MAPPER, docId);
        if (CollectionUtils.isNotEmpty(icsVersionRelationGroupDos)) {
            mainDocId = docId;
        }
        return mainDocId;
    }

    @Override
    public List<IcsVersionRelationGroupDo> getVersionRelationsByDocId(String docId) {
        return null;
    }

    @Override
    public List<IcsVersionRelationGroupDo> getListByProjectIdAndLang(String projectId, String language) {
        return null;
    }

    @Override
    public Set<String> getAllDocId() {
        HashSet<String> docidSet = new HashSet<String>();
        docidSet.addAll(IcsVersionRelationGroupDaoHandler.getInstance().getAllDocId(ICS_VERSION_RELATION_GROUP_MAPPER));
        return docidSet;
    }

    @Override
    public void delVersionRelationPool(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delVersionRelationPool, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return;
        }
        IcsRelationDocIdPoolServiceHandler.getInstance().delPool(docId);
    }

    @Override
    public List<String> getMainDocIdList(String docId) {
        ArrayList<String> docIdList = new ArrayList<String>();
        Set<String> set = IcsVersionRelationGroupDaoHandler.getInstance().getMainDocIdList(ICS_VERSION_RELATION_GROUP_MAPPER, docId);
        if (CollectionUtils.isNotEmpty(set)) {
            docIdList.addAll(set);
        }
        return docIdList;
    }

    @Override
    public List<String> getDocIdByProjectidAndVer(String relationProjectid, String version, String language) {
        ArrayList<String> docIdList = new ArrayList<String>();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{version, relationProjectid, language})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getDocIdByProjectidAndVer , version or relationProjectid  or language is empty");
            return docIdList;
        }
        docIdList.addAll(IcsVersionRelationGroupDaoHandler.getInstance().getByDocIdProjectidAndVer(ICS_VERSION_RELATION_GROUP_MAPPER, relationProjectid, version, language));
        return docIdList;
    }

    private static class IcsVersionRelationPoolServiceHolder {
        private static final IcsVersionRelationPoolServiceHandler INSTANCE = new IcsVersionRelationPoolServiceHandler();

        private IcsVersionRelationPoolServiceHolder() {
        }
    }
}

