/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.meta.dao;

import com.huawei.support.icscbb.hwics.common.meta.constant.IcsMetaConstants;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaNameDo;
import com.huawei.support.icscbb.hwics.common.meta.mapper.IcsMetaNameMapper;
import com.huawei.support.icscbb.hwics.common.meta.parse.SaxIcsMetaName;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsMetaNameDaoHandler
implements IcsMetaConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsMetaNameDaoHandler.class);

    public static IcsMetaNameDaoHandler getInstance() {
        return IcsMetaNameDaoHandlerHolder.INSTANCE;
    }

    private IcsMetaNameDaoHandler() {
    }

    public void createTb(IcsMetaNameMapper metaNameMapper) {
        try {
            metaNameMapper.createTb();
            metaNameMapper.createMetaNameTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'ICSMETANAME' already exists or create error.", e);
        }
    }

    public List<IcsMetaNameDo> create(IcsBaseDo icsBaseDo) {
        ArrayList<IcsMetaNameDo> icsMetaNameList = new ArrayList<IcsMetaNameDo>();
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)"resources/infocenter_service/metadata/meta_name_list.xml");){
            if (null != is) {
                icsMetaNameList.addAll(this.create(is));
                for (IcsMetaNameDo icsMetaNameDo : icsMetaNameList) {
                    IcsBaseService.setContent((IcsBaseDo)icsMetaNameDo, (IcsBaseDo)icsBaseDo);
                }
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  IOException", (Throwable)e);
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return icsMetaNameList;
    }

    public List<IcsMetaNameDo> create(InputStream is) throws SAXException {
        SaxIcsMetaName saxParser = new SaxIcsMetaName();
        SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
        ArrayList<IcsMetaNameDo> icsMetaNameList = new ArrayList<IcsMetaNameDo>();
        saxParser.getIcsMetaName(icsMetaNameList);
        return icsMetaNameList;
    }

    public boolean add(List<IcsMetaNameDo> metaNameList, IcsMetaNameMapper metaNameMapper) {
        int listSize = metaNameList.size();
        boolean isAdd = false;
        if (listSize < 1000) {
            return this.addIcsMetaNameList(metaNameList, metaNameMapper);
        }
        for (int num = 0; num < listSize; num += 1000) {
            isAdd = num + 1000 < listSize ? this.addIcsMetaNameList(metaNameList.subList(num, num + 1000), metaNameMapper) : this.addIcsMetaNameList(metaNameList.subList(num, listSize), metaNameMapper);
            if (isAdd) continue;
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsMetaValueList add fail.");
            break;
        }
        return isAdd;
    }

    private boolean addIcsMetaNameList(List<IcsMetaNameDo> metaNameList, IcsMetaNameMapper metaNameMapper) {
        try {
            metaNameMapper.add(metaNameList);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add ERROR", e);
            return false;
        }
        return true;
    }

    public boolean del(String docId, IcsMetaNameMapper metaNameMapper) {
        try {
            metaNameMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del ERROR", e);
            return false;
        }
        return true;
    }

    public boolean delAll(IcsMetaNameMapper metaNameMapper) {
        try {
            metaNameMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delAll ERROR", e);
            return false;
        }
        return true;
    }

    public List<IcsMetaNameDo> get(String docId, IcsMetaNameMapper metaNameMapper) {
        ArrayList<IcsMetaNameDo> list = new ArrayList<IcsMetaNameDo>();
        try {
            list.addAll(metaNameMapper.get(docId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get ERROR", e);
        }
        return list;
    }

    public Set<String> getAllDocId(IcsMetaNameMapper metaNameMapper) {
        HashSet<String> docidSet = new HashSet<String>();
        try {
            docidSet.addAll(metaNameMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAllDocId ERROR", e);
        }
        return docidSet;
    }

    private static final class IcsMetaNameDaoHandlerHolder {
        private static final IcsMetaNameDaoHandler INSTANCE = new IcsMetaNameDaoHandler();

        private IcsMetaNameDaoHandlerHolder() {
        }
    }
}

