/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.meta.dao;

import com.huawei.support.icscbb.hwics.common.meta.constant.IcsMetaConstants;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaValueDo;
import com.huawei.support.icscbb.hwics.common.meta.mapper.IcsMetaValueMapper;
import com.huawei.support.icscbb.hwics.common.meta.parse.SaxIcsMetaValue;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsMetaValueDaoHandler
implements IcsMetaConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsMetaValueDaoHandler.class);

    public static IcsMetaValueDaoHandler getInstance() {
        return IcsMetaValueDaoHandlerHolder.INSTANCE;
    }

    private IcsMetaValueDaoHandler() {
    }

    public void createTb(IcsMetaValueMapper icsMetaValueMapper) {
        try {
            icsMetaValueMapper.createTb();
            icsMetaValueMapper.createMetaValueTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Table 'ICSMETAVALUE' already exists or create error.", e);
        }
    }

    public List<IcsMetaValueDo> create(IcsBaseDo icsBaseDo) {
        ArrayList<IcsMetaValueDo> icsMetaValueList = new ArrayList<IcsMetaValueDo>();
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)"resources/infocenter_service/metadata/meta_value_list.xml");){
            if (is != null) {
                icsMetaValueList.addAll(this.create(is));
                for (IcsMetaValueDo icsMetaValueDo : icsMetaValueList) {
                    IcsBaseService.setContent((IcsBaseDo)icsMetaValueDo, (IcsBaseDo)icsBaseDo);
                }
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  IOException", (Throwable)e);
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return icsMetaValueList;
    }

    public List<IcsMetaValueDo> create(InputStream is) throws SAXException {
        SaxIcsMetaValue saxParser = new SaxIcsMetaValue();
        SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
        ArrayList<IcsMetaValueDo> icsMetaValueList = new ArrayList<IcsMetaValueDo>();
        saxParser.getIcsMetaValue(icsMetaValueList);
        return icsMetaValueList;
    }

    public boolean add(List<IcsMetaValueDo> icsMetaValueList, IcsMetaValueMapper icsMetaValueMapper) {
        boolean isAdd = false;
        int listSize = icsMetaValueList.size();
        if (listSize < 1000) {
            return this.addIcsMetaValueList(icsMetaValueList, icsMetaValueMapper);
        }
        for (int num = 0; num < listSize; num += 1000) {
            isAdd = num + 1000 < listSize ? this.addIcsMetaValueList(icsMetaValueList.subList(num, num + 1000), icsMetaValueMapper) : this.addIcsMetaValueList(icsMetaValueList.subList(num, listSize), icsMetaValueMapper);
            if (isAdd) continue;
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsMetaValueList add fail.");
            break;
        }
        return isAdd;
    }

    private boolean addIcsMetaValueList(List<IcsMetaValueDo> icsMetaValueList, IcsMetaValueMapper icsMetaValueMapper) {
        try {
            icsMetaValueMapper.add(icsMetaValueList);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add ERROR", e);
            return false;
        }
        return true;
    }

    public boolean del(String docId, IcsMetaValueMapper icsMetaValueMapper) {
        try {
            icsMetaValueMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del ERROR", e);
            return false;
        }
        return true;
    }

    public boolean delAll(IcsMetaValueMapper icsMetaValueMapper) {
        try {
            icsMetaValueMapper.delAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delAll ERROR", e);
            return false;
        }
        return true;
    }

    public List<IcsMetaValueDo> get(String docId, IcsMetaValueMapper icsMetaValueMapper) {
        ArrayList<IcsMetaValueDo> list = new ArrayList<IcsMetaValueDo>();
        try {
            list.addAll(icsMetaValueMapper.get(docId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get ERROR", e);
        }
        return list;
    }

    public List<IcsMetaValueDo> getByMetaNameId(String docId, String metaNameId, IcsMetaValueMapper icsMetaValueMapper) {
        ArrayList<IcsMetaValueDo> list = new ArrayList<IcsMetaValueDo>();
        List<IcsMetaValueDo> icsMetaValueList = this.get(docId, icsMetaValueMapper);
        if (icsMetaValueList != null) {
            for (IcsMetaValueDo icsMetaValue : icsMetaValueList) {
                if (!metaNameId.equals(icsMetaValue.getMetaNameId())) continue;
                list.add(icsMetaValue);
            }
        }
        return list;
    }

    public Set<String> getAllDocId(IcsMetaValueMapper icsMetaValueMapper) {
        HashSet<String> docidSet = new HashSet<String>();
        try {
            docidSet.addAll(icsMetaValueMapper.getAllDocId());
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getAllDocId ERROR", e);
        }
        return docidSet;
    }

    public IcsMetaValueDo getByDocIdAndMetaValueId(String docId, String metaValueId, IcsMetaValueMapper icsMetaValueMapper) {
        IcsMetaValueDo icsMetaValueDo = null;
        List<IcsMetaValueDo> icsMetaValueList = this.get(docId, icsMetaValueMapper);
        if (icsMetaValueList != null) {
            for (IcsMetaValueDo icsMetaValue : icsMetaValueList) {
                if (!metaValueId.equals(icsMetaValue.getMetaValueId())) continue;
                icsMetaValueDo = icsMetaValue;
                break;
            }
        }
        return icsMetaValueDo;
    }

    private static final class IcsMetaValueDaoHandlerHolder {
        private static final IcsMetaValueDaoHandler INSTANCE = new IcsMetaValueDaoHandler();

        private IcsMetaValueDaoHandlerHolder() {
        }
    }
}

