/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.meta.dao;

import com.huawei.support.icscbb.hwics.common.meta.constant.IcsMetaConstants;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaValueRelationDo;
import com.huawei.support.icscbb.hwics.common.meta.mapper.IcsMetaValueRelationMapper;
import com.huawei.support.icscbb.hwics.common.meta.parse.SaxIcsMetaValueRelation;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.libentity.service.IcsBaseService;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class IcsMetaValueRelationDao
implements IcsMetaConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsMetaValueRelationDao.class);
    @Autowired
    IcsMetaValueRelationMapper icsMetaValueRelationMapper;

    public void createTb() {
        try {
            this.icsMetaValueRelationMapper.createTb();
            this.icsMetaValueRelationMapper.createMetaValueRelationTbIndex();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "createTb ERROR", e);
        }
    }

    public List<IcsMetaValueRelationDo> create(InputStream is) throws SAXException {
        SaxIcsMetaValueRelation saxIcsMetaValueRelation = new SaxIcsMetaValueRelation();
        SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxIcsMetaValueRelation);
        ArrayList<IcsMetaValueRelationDo> icsMetaValueList = new ArrayList<IcsMetaValueRelationDo>();
        saxIcsMetaValueRelation.getIcsMetaValueRelation(icsMetaValueList);
        return icsMetaValueList;
    }

    public List<IcsMetaValueRelationDo> create(IcsBaseDo icsBaseDo) {
        ArrayList<IcsMetaValueRelationDo> icsMetaValueRelationDoList = new ArrayList<IcsMetaValueRelationDo>();
        try (InputStream is = ZipFilePool.getInputStream((String)icsBaseDo.getPath(), (String)"resources/infocenter_service/metadata/metavalue_relation.xml");){
            if (is != null) {
                icsMetaValueRelationDoList.addAll(this.create(is));
                for (IcsMetaValueRelationDo icsMetaValueRelationDo : icsMetaValueRelationDoList) {
                    IcsBaseService.setContent((IcsBaseDo)icsMetaValueRelationDo, (IcsBaseDo)icsBaseDo);
                }
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  IOException", (Throwable)e);
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return icsMetaValueRelationDoList;
    }

    public boolean add(List<IcsMetaValueRelationDo> icsMetaValueList) {
        int listSize = icsMetaValueList.size();
        if (listSize < 1000) {
            return this.addIcsMetaValueRelationList(icsMetaValueList);
        }
        boolean flag = false;
        for (int num = 0; num < listSize; num += 1000) {
            flag = num + 1000 < listSize ? this.addIcsMetaValueRelationList(icsMetaValueList.subList(num, num + 1000)) : this.addIcsMetaValueRelationList(icsMetaValueList.subList(num, listSize));
            if (flag) continue;
            CodeCCUtils.INSTANCE.errorLog(LOG, "addIcsMetaValueRelationList add fail.");
            break;
        }
        return flag;
    }

    private boolean addIcsMetaValueRelationList(List<IcsMetaValueRelationDo> icsMetaValueList) {
        try {
            this.icsMetaValueRelationMapper.add(icsMetaValueList);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "add ERROR", e);
            return false;
        }
        return true;
    }

    public boolean del(String docId) {
        try {
            this.icsMetaValueRelationMapper.del(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "del ERROR", e);
            return false;
        }
        return true;
    }

    public List<IcsMetaValueRelationDo> getByDocIdAndStartMetaValueId(String docId, String startMetaValueId) {
        ArrayList<IcsMetaValueRelationDo> list = new ArrayList<IcsMetaValueRelationDo>();
        try {
            list.addAll(this.icsMetaValueRelationMapper.getByDocIdAndStartMetaValueId(docId, startMetaValueId));
        }
        catch (MyBatisSystemException | DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getByDocIdAndStartMetaValueId ERROR", e);
        }
        return list;
    }
}

