/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.meta.service.impl;

import com.huawei.support.icscbb.hwics.common.meta.constant.IcsMetaConstants;
import com.huawei.support.icscbb.hwics.common.meta.dao.IcsMetaNameDaoHandler;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaNameDo;
import com.huawei.support.icscbb.hwics.common.meta.mapper.IcsMetaNameMapper;
import com.huawei.support.icscbb.hwics.common.meta.service.IcsMetaNameService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsMetaNamePoolServiceHandler
extends BasePool<List<IcsMetaNameDo>>
implements IcsMetaNameService,
IcsMetaConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsMetaNamePoolServiceHandler.class);
    private final IcsMetaNameMapper icsMetaNameMapper = (IcsMetaNameMapper)DbMapperUtils.getMapper(IcsMetaNameMapper.class);

    public static IcsMetaNamePoolServiceHandler getInstance() {
        return IcsMetaNamePoolServiceHandlerHolder.INSTANCE;
    }

    private IcsMetaNamePoolServiceHandler() {
    }

    protected void createPool(String key) {
        List<IcsMetaNameDo> metaNameList = IcsMetaNameDaoHandler.getInstance().get(key, this.icsMetaNameMapper);
        if (metaNameList != null) {
            super.addPool(key, metaNameList);
            super.checkPool(10);
        }
    }

    @Override
    public void createTb() {
        IcsMetaNameDaoHandler.getInstance().createTb(this.icsMetaNameMapper);
    }

    @Override
    public boolean add(IcsBaseDo icsBaseDo) {
        List<IcsMetaNameDo> icsMetaNameDoList = IcsMetaNameDaoHandler.getInstance().create(icsBaseDo);
        if (CollectionUtils.isEmpty(icsMetaNameDoList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsMetaValueList is Empty.");
            return false;
        }
        boolean success = IcsMetaNameDaoHandler.getInstance().add(icsMetaNameDoList, this.icsMetaNameMapper);
        if (success) {
            super.addPool(icsBaseDo.getDocId(), icsMetaNameDoList);
        }
        return success;
    }

    @Override
    public boolean del(String docId) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty.");
            return false;
        }
        super.delPool(docId);
        return IcsMetaNameDaoHandler.getInstance().del(docId, this.icsMetaNameMapper);
    }

    @Override
    public boolean delAll() {
        return IcsMetaNameDaoHandler.getInstance().delAll(this.icsMetaNameMapper);
    }

    @Override
    public IcsMetaNameDo get(String docId, String metaNameId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, metaNameId})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaNameId is null.");
            return null;
        }
        return this.getPool(docId, metaNameId);
    }

    public IcsMetaNameDo getPool(String docId, String metaNameId) {
        List metaNameDos = (List)super.getPool(docId);
        if (metaNameDos == null) {
            return null;
        }
        IcsMetaNameDo metaNameDo = null;
        for (IcsMetaNameDo metaName : metaNameDos) {
            if (!metaNameId.equals(metaName.getMetaNameId())) continue;
            metaNameDo = metaName;
            break;
        }
        return metaNameDo;
    }

    @Override
    public Set<String> getAllDocId() {
        return new HashSet<String>(IcsMetaNameDaoHandler.getInstance().getAllDocId(this.icsMetaNameMapper));
    }

    @Override
    public List<IcsMetaNameDo> getMetaNameListByDocId(String docId) {
        return null;
    }

    private static final class IcsMetaNamePoolServiceHandlerHolder {
        private static final IcsMetaNamePoolServiceHandler INSTANCE = new IcsMetaNamePoolServiceHandler();

        private IcsMetaNamePoolServiceHandlerHolder() {
        }
    }
}

