/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.meta.service.impl;

import com.huawei.support.icscbb.hwics.common.meta.constant.IcsMetaConstants;
import com.huawei.support.icscbb.hwics.common.meta.dao.IcsMetaNameDao;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaNameDo;
import com.huawei.support.icscbb.hwics.common.meta.service.IcsMetaNameService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Service;

@Service
@ComponentScan(basePackages={"com.huawei.support.hwics"})
public class IcsMetaNameServiceImpl
implements IcsMetaNameService,
IcsMetaConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsMetaNameServiceImpl.class);
    @Autowired
    private IcsMetaNameDao icsMetaNameDao;

    @Override
    public void createTb() {
        this.icsMetaNameDao.createTb();
    }

    @Override
    public boolean add(IcsBaseDo icsBaseDo) {
        List<IcsMetaNameDo> icsMetaNameDoList = this.icsMetaNameDao.create(icsBaseDo);
        if (CollectionUtils.isEmpty(icsMetaNameDoList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsMetaNameDoList is Empty.");
            return false;
        }
        return this.icsMetaNameDao.add(icsMetaNameDoList);
    }

    @Override
    public boolean del(String docId) {
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return false;
        }
        return this.icsMetaNameDao.del(docId);
    }

    @Override
    public boolean delAll() {
        return false;
    }

    @Override
    public IcsMetaNameDo get(String docId, String metaNameId) {
        if (docId == null || metaNameId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaNameId is null.");
            return null;
        }
        IcsMetaNameDo metaNameDo = null;
        List<IcsMetaNameDo> metaNameList = this.icsMetaNameDao.get(docId);
        if (metaNameList != null) {
            for (IcsMetaNameDo icsMetaNameDo : metaNameList) {
                if (!metaNameId.equals(icsMetaNameDo.getMetaNameId())) continue;
                metaNameDo = icsMetaNameDo;
                break;
            }
        }
        return metaNameDo;
    }

    @Override
    public Set<String> getAllDocId() {
        HashSet<String> docidSet = new HashSet<String>();
        docidSet.addAll(this.icsMetaNameDao.getAllDocId());
        return docidSet;
    }

    @Override
    public List<IcsMetaNameDo> getMetaNameListByDocId(String docId) {
        ArrayList<IcsMetaNameDo> icsMetaNameDoList = new ArrayList<IcsMetaNameDo>();
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get MetaName list failed, docId is null");
            return icsMetaNameDoList;
        }
        icsMetaNameDoList.addAll(this.icsMetaNameDao.get(docId));
        if (CollectionUtils.isEmpty(icsMetaNameDoList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get MetaName list failed, docId{0}", new Object[]{docId});
            return icsMetaNameDoList;
        }
        return icsMetaNameDoList;
    }
}

