/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.meta.service.impl;

import com.huawei.support.icscbb.hwics.common.meta.constant.IcsMetaConstants;
import com.huawei.support.icscbb.hwics.common.meta.dao.IcsMetaValueDaoHandler;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaValueDo;
import com.huawei.support.icscbb.hwics.common.meta.mapper.IcsMetaValueMapper;
import com.huawei.support.icscbb.hwics.common.meta.service.IcsMetaValueService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsMetaValuePoolServiceHandler
extends BasePool<List<IcsMetaValueDo>>
implements IcsMetaValueService,
IcsMetaConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsMetaValuePoolServiceHandler.class);
    private final IcsMetaValueMapper icsMetaValueMapper = (IcsMetaValueMapper)DbMapperUtils.getMapper(IcsMetaValueMapper.class);

    public static IcsMetaValuePoolServiceHandler getInstance() {
        return IcsMetaValuePoolServiceHandlerHolder.INSTANCE;
    }

    private IcsMetaValuePoolServiceHandler() {
    }

    protected void createPool(String docId) {
        List<IcsMetaValueDo> icsMetaValueList = IcsMetaValueDaoHandler.getInstance().get(docId, this.icsMetaValueMapper);
        if (icsMetaValueList != null) {
            super.addPool(docId, icsMetaValueList);
            super.checkPool(10);
        }
    }

    @Override
    public void createTb() {
        IcsMetaValueDaoHandler.getInstance().createTb(this.icsMetaValueMapper);
    }

    @Override
    public boolean add(IcsBaseDo icsBaseDo) {
        List<IcsMetaValueDo> icsMetaValueList = IcsMetaValueDaoHandler.getInstance().create(icsBaseDo);
        if (CollectionUtils.isEmpty(icsMetaValueList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsMetaValueList is Empty.");
            return false;
        }
        boolean success = IcsMetaValueDaoHandler.getInstance().add(icsMetaValueList, this.icsMetaValueMapper);
        if (success) {
            super.addPool(icsBaseDo.getDocId(), icsMetaValueList);
        }
        return success;
    }

    @Override
    public boolean del(String docId) {
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return false;
        }
        super.delPool(docId);
        return IcsMetaValueDaoHandler.getInstance().del(docId, this.icsMetaValueMapper);
    }

    @Override
    public boolean delAll() {
        return IcsMetaValueDaoHandler.getInstance().delAll(this.icsMetaValueMapper);
    }

    @Override
    public IcsMetaValueDo get(String docId, String metaValueId) {
        List icsMetaValueList = (List)super.getPool(docId);
        if (icsMetaValueList == null) {
            return null;
        }
        IcsMetaValueDo icsMetaValueDo = null;
        for (IcsMetaValueDo icsMetaValue : icsMetaValueList) {
            if (!metaValueId.equals(icsMetaValue.getMetaValueId())) continue;
            icsMetaValueDo = icsMetaValue;
            break;
        }
        return icsMetaValueDo;
    }

    @Override
    public List<IcsMetaValueDo> getByMetaNameId(String docId, String metaNameId) {
        ArrayList<IcsMetaValueDo> list = new ArrayList<IcsMetaValueDo>();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, metaNameId})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaNameId is null.");
            return list;
        }
        List icsMetaValueDos = (List)super.getPool(docId);
        if (icsMetaValueDos == null) {
            return list;
        }
        for (IcsMetaValueDo icsMetaValue : icsMetaValueDos) {
            if (!metaNameId.equals(icsMetaValue.getMetaNameId())) continue;
            list.add(icsMetaValue);
        }
        return list;
    }

    @Override
    public Set<String> getAllDocId() {
        return new HashSet<String>(IcsMetaValueDaoHandler.getInstance().getAllDocId(this.icsMetaValueMapper));
    }

    @Override
    public List<IcsMetaValueDo> getMetaValueListByDocId(String docId) {
        return null;
    }

    private static final class IcsMetaValuePoolServiceHandlerHolder {
        private static final IcsMetaValuePoolServiceHandler INSTANCE = new IcsMetaValuePoolServiceHandler();

        private IcsMetaValuePoolServiceHandlerHolder() {
        }
    }
}

