/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.meta.service.impl;

import com.huawei.support.icscbb.hwics.common.meta.constant.IcsMetaConstants;
import com.huawei.support.icscbb.hwics.common.meta.dao.IcsMetaValueDao;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaValueDo;
import com.huawei.support.icscbb.hwics.common.meta.service.IcsMetaValueService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Service;

@Service
@ComponentScan(basePackages={"com.huawei.support.hwics"})
public class IcsMetaValueServiceImpl
implements IcsMetaValueService,
IcsMetaConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsMetaValueServiceImpl.class);
    @Autowired
    private IcsMetaValueDao icsMetaValueDao;

    @Override
    public void createTb() {
        this.icsMetaValueDao.createTb();
    }

    @Override
    public boolean add(IcsBaseDo icsBaseDo) {
        List<IcsMetaValueDo> icsMetaValueList = this.icsMetaValueDao.create(icsBaseDo);
        if (CollectionUtils.isEmpty(icsMetaValueList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsMetaValueList is Empty.");
            return false;
        }
        return this.icsMetaValueDao.add(icsMetaValueList);
    }

    @Override
    public boolean del(String docId) {
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return false;
        }
        return this.icsMetaValueDao.del(docId);
    }

    @Override
    public boolean delAll() {
        return false;
    }

    @Override
    public IcsMetaValueDo get(String docId, String metaValueId) {
        if (docId == null || metaValueId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaValueId is null.");
            return null;
        }
        return this.icsMetaValueDao.getByDocIdAndMetaValueId(docId, metaValueId);
    }

    @Override
    public List<IcsMetaValueDo> getByMetaNameId(String docId, String metaNameId) {
        ArrayList<IcsMetaValueDo> list = new ArrayList<IcsMetaValueDo>();
        if (docId == null || metaNameId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaNameId is null.");
            return list;
        }
        list.addAll(this.icsMetaValueDao.getByMetaNameId(docId, metaNameId));
        return list;
    }

    @Override
    public Set<String> getAllDocId() {
        HashSet<String> docidSet = new HashSet<String>();
        docidSet.addAll(this.icsMetaValueDao.getAllDocId());
        return docidSet;
    }

    @Override
    public List<IcsMetaValueDo> getMetaValueListByDocId(String docId) {
        ArrayList<IcsMetaValueDo> icsMetaNameDoList = new ArrayList<IcsMetaValueDo>();
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get MetaValue list failed, docId is null");
            return icsMetaNameDoList;
        }
        icsMetaNameDoList.addAll(this.icsMetaValueDao.get(docId));
        if (CollectionUtils.isEmpty(icsMetaNameDoList)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get MetaValue list failed, docId{0}", new Object[]{docId});
            return icsMetaNameDoList;
        }
        return icsMetaNameDoList;
    }
}

