/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.dao;

import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviStatusMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public class IcsNaviStatusDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviStatusDaoHandler.class);

    public static void createNaviTopicTb(IcsNaviStatusMapper icsNaviStatusMapper) {
        try {
            icsNaviStatusMapper.createTb();
            icsNaviStatusMapper.createTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Table 'ICSPIDSTATUS' already exists or create error.", e);
        }
    }

    public static void addList(IcsNaviStatusMapper icsNaviStatusMapper, List<IcsNaviStatusDo> list) {
        try {
            icsNaviStatusMapper.addList(list);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "ICS status addList Error.", e);
        }
    }

    public static void add(IcsNaviStatusMapper icsNaviStatusMapper, IcsNaviStatusDo status) {
        try {
            icsNaviStatusMapper.add(status);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "ICS status add Error.", e);
        }
    }

    public static void delete(IcsNaviStatusMapper icsNaviStatusMapper, String docId) {
        try {
            icsNaviStatusMapper.delete(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "ICS status delete Error.", e);
        }
    }

    public static boolean deleteAll(IcsNaviStatusMapper icsNaviStatusMapper) {
        try {
            icsNaviStatusMapper.deleteAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "ICS status deleteAll Error.", e);
            return false;
        }
        return true;
    }

    public static IcsNaviStatusDo getPidByDocId(IcsNaviStatusMapper icsNaviStatusMapper, Map<String, String> map) {
        IcsNaviStatusDo status = null;
        try {
            status = icsNaviStatusMapper.getPidByDocId(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getPidByDocId Error.", e);
        }
        return status;
    }

    public static void updateStatus(IcsNaviStatusMapper icsNaviStatusMapper, IcsNaviStatusDo statusDo) {
        try {
            icsNaviStatusMapper.updateStatus(statusDo);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "updateStatus Error.", e);
        }
    }

    public static List<String> getDocIdsByStatus(IcsNaviStatusMapper icsNaviStatusMapper, List<String> list) {
        List<Object> docIdList = new ArrayList();
        try {
            docIdList = icsNaviStatusMapper.getDocIdsByStatus(list);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getDocIdByStatus Error.", e);
        }
        return Optional.ofNullable(docIdList).orElse(new ArrayList());
    }

    public static List<IcsNaviStatusDo> getUnfinishedDoc(IcsNaviStatusMapper icsNaviStatusMapper) {
        List<IcsNaviStatusDo> statusDoList = new ArrayList<IcsNaviStatusDo>();
        try {
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("101");
            statusList.add("102");
            statusList.add("201");
            statusList.add("202");
            statusDoList = icsNaviStatusMapper.getUnfinishedDoc(statusList);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getUnfinishedDoc Error.", e);
        }
        return statusDoList;
    }

    public static List<IcsNaviStatusDo> getDocStatusByDocId(IcsNaviStatusMapper icsNaviStatusMapper, String docId) {
        List<IcsNaviStatusDo> status = null;
        try {
            status = icsNaviStatusMapper.getDocStatusByDocId(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getDocStatusByDocId Error.", e);
        }
        return Optional.ofNullable(status).orElse(new ArrayList());
    }
}

