/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.dao;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviCountHandler;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviHandler;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsPortalNaviHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsNaviTopicDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicDaoHandler.class);

    public static void createNaviTopicTb(IcsNaviTopicMapper icsNaviTopicMapper) {
        try {
            icsNaviTopicMapper.createNaviTopicTb();
            icsNaviTopicMapper.createNaviTopicTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Table 'ICSTOPIC' already exists or create error.", e);
        }
    }

    public static void addNaviTopic(IcsNaviTopicMapper icsNaviTopicMapper, IcsTopicDo naviTopic) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("topic", naviTopic);
            icsNaviTopicMapper.addNaviTopic(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "addNaviTopic Error.", e);
        }
    }

    public static void addNaviTopics(IcsNaviTopicMapper icsNaviTopicMapper, List<IcsTopicDo> naviTopics) {
        int index = 1;
        if (CollectionUtils.isEmpty(naviTopics)) {
            return;
        }
        int listSize = naviTopics.size();
        try {
            List<IcsTopicDo> tempList;
            while (listSize > index * 100) {
                tempList = naviTopics.subList((index - 1) * 100, index * 100);
                icsNaviTopicMapper.addNaviTopics(tempList);
                ++index;
            }
            tempList = naviTopics.subList((index - 1) * 100, listSize);
            if (!tempList.isEmpty()) {
                icsNaviTopicMapper.addNaviTopics(tempList);
            }
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "addNaviTopics Error.", e);
        }
    }

    public static void deleteNaviTopics(IcsNaviTopicMapper icsNaviTopicMapper, String docId) {
        try {
            icsNaviTopicMapper.deleteNaviTopics(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "deleteNaviTopics Error.", e);
        }
    }

    public static int getTopicsCount(IcsNaviTopicMapper icsNaviTopicMapper, String docId) {
        int count = 0;
        try {
            count = icsNaviTopicMapper.getTopicsCount(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "deleteNaviTopics Error.", e);
        }
        return count;
    }

    public static void deleteAll(IcsNaviTopicMapper icsNaviTopicMapper) {
        try {
            icsNaviTopicMapper.deleteAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IcsNaviTopicMapper deleteAll Error.", e);
        }
    }

    public static IcsTopicDo getNaviTopic(IcsNaviTopicMapper icsNaviTopicMapper, String docId, String topicId) {
        IcsTopicDo moduleTopicDto = null;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, topicId})) {
            return moduleTopicDto;
        }
        map.put("topicId", topicId);
        map.put("docId", docId);
        List<IcsTopicDo> naviTopics = null;
        try {
            naviTopics = icsNaviTopicMapper.getNaviTopics(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getNaviTopicWithFilter Error.", e);
        }
        if (CollectionUtils.isNotEmpty(naviTopics)) {
            moduleTopicDto = naviTopics.get(0);
        }
        return moduleTopicDto;
    }

    public static List<IcsTopicDo> getTopicPidsByDocId(IcsNaviTopicMapper icsNaviTopicMapper, String docId, String pidId) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("docId", docId);
        map.put("topicPid", "true");
        if (StringUtils.isNotBlank((CharSequence)pidId)) {
            map.put("pidId", pidId);
        }
        List<IcsTopicDo> naviTopicsWithFilter = null;
        try {
            naviTopicsWithFilter = icsNaviTopicMapper.getNaviTopics(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getTopicPidsByDocId Error.", e);
        }
        return naviTopicsWithFilter;
    }

    public static List<IcsTopicDo> getTopicsByDocId(IcsNaviTopicMapper icsNaviTopicMapper, String docId, String pidId, String retopic) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("docId", docId);
        map.put("topicPid", "false");
        map.put("retopic", retopic);
        if (StringUtils.isNotBlank((CharSequence)pidId)) {
            map.put("pidId", pidId);
        }
        List<IcsTopicDo> naviTopicsWithFilter = null;
        try {
            naviTopicsWithFilter = icsNaviTopicMapper.getNaviTopics(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getTopicsByDocId Error.", e);
        }
        return naviTopicsWithFilter;
    }

    public static IcsTopicDo getOneTopicInNavi(IcsNaviTopicMapper icsNaviTopicMapper, String docId, String pidId, String topicId, String topicUrl) {
        IcsTopicDo topic = null;
        try {
            topic = icsNaviTopicMapper.getOneTopicInNavi(docId, pidId, topicId, topicUrl);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "icsNaviTopicMapper.getOneTopicInNavi Error", e);
        }
        return topic;
    }

    public static List<String> getPidsByDocId(IcsNaviTopicMapper icsNaviTopicMapper, String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            return new ArrayList<String>();
        }
        List<String> list = null;
        try {
            list = icsNaviTopicMapper.getPidsByDocId(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "icsNaviTopicMapper.getPidsByDocId Error", e);
        }
        return list;
    }

    public static List<IcsTopicDo> getNaviByPosition(String pidXmlPath, String naviPositions) {
        IcsNaviHandler hdxNaviHandler = new IcsNaviHandler(naviPositions);
        if (IcsNaviTopicDaoHandler.parseXml(hdxNaviHandler, pidXmlPath)) {
            return hdxNaviHandler.getIcsTopicDoList();
        }
        return Collections.emptyList();
    }

    public static List<IcsTopicDo> getNaviListByPidXmlPath(String pidXmlPath) {
        IcsPortalNaviHandler hdxNaviHandler = new IcsPortalNaviHandler();
        if (IcsNaviTopicDaoHandler.parseXml(hdxNaviHandler, pidXmlPath)) {
            return hdxNaviHandler.getIcsTopicDoList();
        }
        return Collections.emptyList();
    }

    public static int getCountByPosition(String pidXmlPath, String naviPositions) {
        IcsNaviCountHandler hdxNaviHandler = new IcsNaviCountHandler(naviPositions);
        if (IcsNaviTopicDaoHandler.parseXml(hdxNaviHandler, pidXmlPath)) {
            return hdxNaviHandler.getCount();
        }
        return 0;
    }

    private static boolean parseXml(EventListener eventListener, String naviXmlPath) {
        XmlSaxParser xmlSaxParser = new XmlSaxParser(eventListener, new ParserContext());
        try (FileInputStream fileInputStream = FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{naviXmlPath}));){
            SAXParserUtils.parseXml((InputStream)fileInputStream, (DefaultHandler)xmlSaxParser);
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Ics Navi Parse fail.", (Throwable)e);
            return false;
        }
        return true;
    }
}

