/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.dao;

import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicMetaDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicPageDto;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMetaMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.CollectionUtils;

public class IcsNaviTopicMetaDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicMetaDaoHandler.class);

    public static void creatTopicMetaTb(IcsNaviTopicMetaMapper naviTopicMetaMapper) {
        try {
            naviTopicMetaMapper.createTopicMetaTb();
            naviTopicMetaMapper.createTopicMetaTbIndex();
            naviTopicMetaMapper.transferDataToNewTable();
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "TopicMetaTb transfer data end.");
            naviTopicMetaMapper.deleteOldTable();
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "TopicMetaTb delete old table end.");
        }
        catch (BadSqlGrammarException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Transfer Data fail, maybe the old table may not exist", (Throwable)e);
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Table 'ICSTOPICMETA' already exists or create error.", e);
        }
    }

    public static void addNaviTopicMetas(IcsNaviTopicMetaMapper naviTopicMetaMapper, List<IcsTopicMetaDo> naviTopics) {
        try {
            List<IcsTopicMetaDo> tempList;
            int index = 1;
            if (CollectionUtils.isEmpty(naviTopics)) {
                return;
            }
            int listSize = naviTopics.size();
            while (listSize > index * 100) {
                tempList = naviTopics.subList((index - 1) * 100, index * 100);
                naviTopicMetaMapper.addNaviTopicMetas(tempList);
                ++index;
            }
            tempList = naviTopics.subList((index - 1) * 100, listSize);
            if (!tempList.isEmpty()) {
                naviTopicMetaMapper.addNaviTopicMetas(tempList);
            }
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "addNaviTopicMetas Error.", e);
        }
    }

    public static void deleteNaviTopicMetas(IcsNaviTopicMetaMapper naviTopicMetaMapper, String docId) {
        try {
            naviTopicMetaMapper.deleteNaviTopicMetas(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "deleteNaviTopicMetas Error.", e);
        }
    }

    public static void deleteAll(IcsNaviTopicMetaMapper naviTopicMetaMapper) {
        try {
            naviTopicMetaMapper.deleteAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "NaviTopicMetaMapper deleteAll Error.", e);
        }
    }

    public static void addNaviTopicMeta(IcsNaviTopicMetaMapper naviTopicMetaMapper, IcsTopicDo topicDto, IcsTopicMetaDo metaInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("topicDto", topicDto);
        map.put("metaInfo", metaInfo);
        try {
            naviTopicMetaMapper.addNaviTopicMeta(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "addNaviTopicMeta Error.", e);
        }
    }

    public static List<IcsTopicMetaDo> getTopicMetaList(IcsNaviTopicMetaMapper naviTopicMetaMapper, String docId, String pidId) {
        List<IcsTopicMetaDo> topicMetaList = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("docId", docId);
            map.put("pidId", pidId);
            topicMetaList = naviTopicMetaMapper.getTopicMetaList(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getTopicMetaList Error.", e);
        }
        return topicMetaList;
    }

    public static IcsTopicDo getTopicByDocId(IcsNaviTopicMetaMapper naviTopicMetaMapper, String docId, String topicId) {
        IcsTopicDo topic = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("docId", docId);
            map.put("topicId", topicId);
            topic = naviTopicMetaMapper.getTopicByDocId(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getTopicMetaList Error.", e);
        }
        return topic;
    }

    public static int getTopicsCount(IcsNaviTopicMetaMapper naviTopicMetaMapper, String docId) {
        int count = 0;
        try {
            count = naviTopicMetaMapper.getTopicsCount(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "deleteNaviTopicMetas Error.", e);
        }
        return count;
    }

    public static List<IcsTopicMetaDo> getTopicsByPage(IcsNaviTopicMetaMapper naviTopicMetaMapper, IcsTopicPageDto pageDTO) {
        List<IcsTopicMetaDo> topics = null;
        try {
            topics = naviTopicMetaMapper.getTopicsByPage(pageDTO);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "deleteNaviTopicMetas Error.", e);
        }
        return topics;
    }

    public static IcsTopicMetaDo getTopicByTopicUrl(IcsNaviTopicMetaMapper naviTopicMetaMapper, String docId, String topicUrl) {
        IcsTopicMetaDo topic = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("docId", docId);
            map.put("topicUrl", topicUrl);
            topic = naviTopicMetaMapper.getTopicByTopicUrl(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getTopicMetaList Error.", e);
        }
        return topic;
    }
}

