/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.dao;

import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicRelationDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicRelationMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataIntegrityViolationException;

public class IcsNaviTopicRelationDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicRelationDaoHandler.class);
    private static final int INSERT_BATCH_SIZE = 1000;

    public static void addNaviTopicRelations(IcsNaviTopicRelationMapper naviTopicRelationMapper, List<IcsTopicRelationDo> naviTopics) {
        try {
            List<IcsTopicRelationDo> tempList;
            int index = 1;
            if (CollectionUtils.isEmpty(naviTopics)) {
                return;
            }
            int listSize = naviTopics.size();
            while (listSize > index * 1000) {
                tempList = naviTopics.subList((index - 1) * 1000, index * 1000);
                naviTopicRelationMapper.addNaviTopicRelations(tempList);
                ++index;
            }
            tempList = naviTopics.subList((index - 1) * 1000, listSize);
            if (!tempList.isEmpty()) {
                naviTopicRelationMapper.addNaviTopicRelations(tempList);
            }
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "addNaviTopicRelations Error.", e);
        }
    }

    public static void deleteNaviTopicRelations(IcsNaviTopicRelationMapper naviTopicRelationMapper, String docId) {
        try {
            naviTopicRelationMapper.deleteNaviTopicRelations(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "deleteNaviTopicRelations Error.", e);
        }
    }

    public static void deleteAll(IcsNaviTopicRelationMapper naviTopicRelationMapper) {
        try {
            naviTopicRelationMapper.deleteAll();
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IcsNaviTopicRelationMapper deleteAll Error.", e);
        }
    }

    public static void addTopicRelationDto(IcsNaviTopicRelationMapper naviTopicRelationMapper, IcsTopicDo topicDto, IcsTopicRelationDo relationDto) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("topicDto", topicDto);
            map.put("relationDto", relationDto);
            naviTopicRelationMapper.addTopicRelationDTO(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "addTopicRelationDto Error.", e);
        }
    }

    public static List<IcsTopicRelationDo> getRelationsByTopicId(IcsNaviTopicRelationMapper naviTopicRelationMapper, String docId, String topicId) {
        List<IcsTopicRelationDo> topicRelations = new ArrayList<IcsTopicRelationDo>(0);
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, topicId})) {
                return topicRelations;
            }
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("docId", docId);
            map.put("topicIdList", topicId);
            topicRelations = naviTopicRelationMapper.getTopicRelationByTopicId(map);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "getRelationsByTopicId Error.", e);
        }
        return topicRelations;
    }

    public static void creatTopicRelationTb(IcsNaviTopicRelationMapper naviTopicRelationMapper) {
        try {
            naviTopicRelationMapper.createTopicRelationTb();
            naviTopicRelationMapper.createTopicRelationTbIndex();
        }
        catch (PersistenceException | MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Table 'ICSTOPICRELATION' already exists or create error.", e);
        }
    }
}

