/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.parse;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.hwics.common.navi.dto.NaviXmlQueryDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.QueryMetaAndFilterDto;
import com.huawei.support.icscbb.hwics.common.navi.parse.SaxParserIcsNavi;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsNaviXmlDaoHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviXmlDaoHandler.class);

    public static boolean remove(IcsLiteStorageAdapter icsLiteStorageAdapter, String docId) {
        File naviFile = FileUtils.getFile((String[])new String[]{IcsNaviUtil.getDocDirPath(docId, icsLiteStorageAdapter.getIcsNavPath())});
        if (!naviFile.exists() || IcsFileUtils.delFileOrDir((File)naviFile, (String)icsLiteStorageAdapter.getIcsNavPath())) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "delete navDir success. docId: {0}", new Object[]{docId});
            return true;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "delete navDir failed. docId: {0}", new Object[]{docId});
        return false;
    }

    public static String getAll(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId, List<QueryMetaAndFilterDto> queryMetaAndFilterDtos) {
        return IcsNaviXmlDaoHandler.getTopicsBySax(icsLiteStorageAdapter, maindDocId, docId, pidId, new SaxParserIcsNavi(new NaviXmlQueryDo().setDocId(docId).setPidId(pidId).setQueryMetaAndFilterDtos(queryMetaAndFilterDtos), SaxParserIcsNavi.Branch.ALLNAVIS));
    }

    public static String getFirstFloor(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId) {
        return IcsNaviXmlDaoHandler.getTopicsBySax(icsLiteStorageAdapter, maindDocId, docId, pidId, new SaxParserIcsNavi(docId, pidId, SaxParserIcsNavi.Branch.FIRSTFLOOR));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getTopicsBySax(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId, SaxParserIcsNavi parser) {
        try (InputStream is = IcsNaviXmlDaoHandler.getNewNaviXmlInputStream(icsLiteStorageAdapter, maindDocId, docId, pidId);){
            if (is == null) {
                String string = "";
                return string;
            }
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)parser);
            String result = parser.getTopicStr();
            return result;
        }
        catch (IOException | SAXException e) {
            return "3";
        }
    }

    private static String getTopicPositionBySax(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId, SaxParserIcsNavi parser) {
        if (parser == null || !IcsNaviXmlDaoHandler.parseNav(icsLiteStorageAdapter, maindDocId, docId, pidId, parser)) {
            return "";
        }
        return parser.getPostion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean parseNav(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId, SaxParserIcsNavi parser) {
        boolean rst = false;
        try (InputStream is = IcsNaviXmlDaoHandler.getNewNaviXmlInputStream(icsLiteStorageAdapter, maindDocId, docId, pidId);){
            if (is == null) {
                boolean bl = rst;
                return bl;
            }
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)parser);
            rst = true;
            return rst;
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, String.format(Locale.ENGLISH, "Exception, when getNaviXmlDocument, docId: %s", docId), (Throwable)e);
        }
        return rst;
    }

    private static InputStream getNewNaviXmlInputStream(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId) throws IOException {
        return FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{IcsNaviUtil.getPidXmlPath(maindDocId, docId, pidId, icsLiteStorageAdapter.getIcsNavPath())}));
    }

    public static String getChilds(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId, String position) {
        return IcsNaviXmlDaoHandler.getTopicsBySax(icsLiteStorageAdapter, maindDocId, docId, pidId, new SaxParserIcsNavi(new NaviXmlQueryDo().setDocId(docId).setPosition(position), SaxParserIcsNavi.Branch.GETCHILD));
    }

    public static String getByTopicId(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId, String topicId) {
        String targetPostion = IcsNaviXmlDaoHandler.getTopicPositionBySax(icsLiteStorageAdapter, maindDocId, docId, pidId, new SaxParserIcsNavi(new NaviXmlQueryDo().setDocId(docId).setTopicId(topicId), SaxParserIcsNavi.Branch.FINDBYID));
        if (StringUtils.isBlank((CharSequence)targetPostion)) {
            return "";
        }
        return IcsNaviXmlDaoHandler.getTopicsBySax(icsLiteStorageAdapter, maindDocId, docId, pidId, new SaxParserIcsNavi(new NaviXmlQueryDo().setDocId(docId).setPosition(targetPostion), SaxParserIcsNavi.Branch.GETBYPOSITION));
    }

    public static String getByTopicUrl(IcsLiteStorageAdapter icsLiteStorageAdapter, String maindDocId, String docId, String pidId, String topicUrl) {
        String targetPostion = IcsNaviXmlDaoHandler.getTopicPositionBySax(icsLiteStorageAdapter, maindDocId, docId, pidId, new SaxParserIcsNavi(new NaviXmlQueryDo().setDocId(docId).setTopicUrl(topicUrl), SaxParserIcsNavi.Branch.FINDBYURL));
        if (StringUtils.isBlank((CharSequence)targetPostion)) {
            return "";
        }
        return IcsNaviXmlDaoHandler.getTopicsBySax(icsLiteStorageAdapter, maindDocId, docId, pidId, new SaxParserIcsNavi(new NaviXmlQueryDo().setDocId(docId).setPosition(targetPostion), SaxParserIcsNavi.Branch.GETBYPOSITION));
    }
}

