/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.parse;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicBaseDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMapper;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParserNavi
extends DefaultHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SAXParserNavi.class);
    private static final IcsNaviTopicMapper ICS_TOPIC_MAPPER = (IcsNaviTopicMapper)DbMapperUtils.getMapper(IcsNaviTopicMapper.class);
    private static final int TOPICDTOLIST_MAX = 100;
    private IcsNaviTopicDao icsNaviTopicDao;
    private Stack<String> topicIdStack = new Stack();
    private List<IcsTopicDo> topicDtoList = new ArrayList<IcsTopicDo>(100);
    private IcsTopicDo topicDto = null;
    private String isParent;
    private String nowPosition;
    private String pidId;
    private String hdxFileId;
    private String projectId;
    private String lang;
    private String issuedate;

    public SAXParserNavi(IcsTopicBaseDo profile, String pidId, IcsNaviTopicDao naviTopicDao) {
        this.icsNaviTopicDao = naviTopicDao;
        this.pidId = Optional.ofNullable(pidId).orElse("");
        this.hdxFileId = Optional.ofNullable(profile.getDocId()).orElse("");
        this.projectId = Optional.ofNullable(profile.getProjectId()).orElse("");
        this.lang = Optional.ofNullable(profile.getLang()).orElse("");
        this.issuedate = Optional.ofNullable(profile.getIssuedate()).orElse("");
        this.topicIdStack.push("");
        this.nowPosition = ".0";
        this.isParent = "false";
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) {
        if ("topic".equals(qname)) {
            this.addTopicDto(this.isParent);
            String position = this.getPosition();
            String parentPosition = this.getParentPosition();
            String parentTopicId = this.topicIdStack.peek();
            String topicId = this.createTopicDto(attributes, parentTopicId, position, parentPosition);
            this.topicIdStack.push(topicId);
            this.positionPush();
            this.isParent = "true";
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "%s.xml startElement unKnow qName:%s ", this.pidId, qname));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if ("topic".equals(qname)) {
            this.topicIdStack.pop();
            this.positionPop();
            this.isParent = "false";
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "%s.xml endElement unKnow qName:%s ", this.pidId, qname));
        }
    }

    @Override
    public void endDocument() {
        this.addTopicDto(this.isParent);
        this.endAddTopicDto();
    }

    private String createTopicDto(Attributes attributes, String parentTopicId, String position, String parentPosition) {
        this.topicDto = new IcsTopicDo();
        this.topicDto.setDocId(this.hdxFileId);
        this.topicDto.setProjectId(this.projectId);
        this.topicDto.setLang(this.lang);
        this.topicDto.setIssuedate(this.issuedate);
        this.topicDto.setPidId(this.pidId);
        String topicId = IcsNaviUtil.getAttributeValue(attributes, "id");
        this.topicDto.setTopicId(topicId);
        this.topicDto.setName(IcsNaviUtil.getAttributeValue(attributes, "name"));
        this.topicDto.setTopicPidId(IcsNaviUtil.getAttributeValue(attributes, "pid_id"));
        this.topicDto.setParentTopicId(parentTopicId);
        this.topicDto.setParentPosition(parentPosition);
        this.topicDto.setPosition(position);
        this.topicDto.setCtime(new Date());
        return topicId;
    }

    private void addTopicDto(String isParentVal) {
        if (this.topicDto != null) {
            this.topicDto.setIsParent(isParentVal);
            this.topicDtoList.add(this.topicDto);
        }
        if (this.topicDtoList.size() >= 100) {
            this.putTopicDataToDb();
        }
        this.topicDto = null;
    }

    private void endAddTopicDto() {
        if (this.topicDtoList.size() > 0) {
            this.putTopicDataToDb();
        }
        this.topicDtoList = null;
    }

    private void putTopicDataToDb() {
        if (this.icsNaviTopicDao != null) {
            this.icsNaviTopicDao.addNaviTopics(this.topicDtoList);
        } else {
            IcsNaviTopicDaoHandler.addNaviTopics(ICS_TOPIC_MAPPER, this.topicDtoList);
        }
        this.topicDtoList.clear();
    }

    private String getParentPosition() {
        int index = this.nowPosition.lastIndexOf(".");
        if (index <= 0) {
            return "";
        }
        return this.nowPosition.substring(1, index);
    }

    private String getPosition() {
        int index = this.nowPosition.lastIndexOf(".");
        int position = Integer.parseInt(this.nowPosition.substring(index + 1)) + 1;
        this.nowPosition = this.nowPosition.substring(0, index) + "." + position;
        return this.nowPosition.substring(1);
    }

    private void positionPush() {
        this.nowPosition = this.nowPosition + ".0";
    }

    private void positionPop() {
        int index = this.nowPosition.lastIndexOf(".");
        this.nowPosition = this.nowPosition.substring(0, index);
    }
}

