/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.parse;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicRelationDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicRelationDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicBaseDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicMetaDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicRelationDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.QueryMetaAndFilterDto;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMetaMapper;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicRelationMapper;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParserTopicMeta
extends DefaultHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SAXParserTopicMeta.class);
    private static final int TOPICDTOLIST_MAX = 100;
    private static final IcsNaviTopicMetaMapper ICS_TOPICMETA_MAPPER = (IcsNaviTopicMetaMapper)DbMapperUtils.getMapper(IcsNaviTopicMetaMapper.class);
    private static final IcsNaviTopicRelationMapper ICS_TOPICRELATION_MAPPER = (IcsNaviTopicRelationMapper)DbMapperUtils.getMapper(IcsNaviTopicRelationMapper.class);
    private IcsNaviTopicMetaDao icsNaviTopicMetaDao;
    private List<IcsTopicMetaDo> icsTopicMetaDoList = new ArrayList<IcsTopicMetaDo>(100);
    private IcsNaviTopicRelationDao icsNaviTopicRelationDao;
    private List<IcsTopicRelationDo> icsTopicRelationDtoList = new ArrayList<IcsTopicRelationDo>(100);
    private IcsTopicMetaDo topicMetaDto = null;
    private Map<String, String> propertysMap = null;
    private Map<String, QueryMetaAndFilterDto> queryMap = null;
    private List<QueryMetaAndFilterDto> tagsList = null;
    private String docId;
    private String projectId;
    private String lang;
    private String issuedate;
    private boolean isTopicChild;
    private boolean isPropertyChild;
    private boolean isTagsChild;
    private boolean isRelationsChild;
    private int topicMetaNum = 0;
    private int topicRelationNum = 0;
    private String targetTopicId;
    private boolean branch = false;
    private boolean isTargetChild = false;
    private IcsTopicMetaDo targetTopicDo;

    public SAXParserTopicMeta(IcsTopicBaseDo profile, IcsNaviTopicMetaDao naviTopicMetaDao, IcsNaviTopicRelationDao naviTopicRelationDao) {
        this.icsNaviTopicMetaDao = naviTopicMetaDao;
        this.icsNaviTopicRelationDao = naviTopicRelationDao;
        this.docId = profile.getDocId();
        this.projectId = profile.getProjectId();
        this.lang = profile.getLang();
        this.issuedate = profile.getIssuedate();
        this.isTopicChild = false;
        this.isPropertyChild = false;
        this.isTagsChild = false;
        this.isRelationsChild = false;
    }

    public SAXParserTopicMeta(String docid, String topicId) {
        this.docId = docid;
        this.targetTopicId = topicId;
        this.branch = true;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("topics".equals(qName)) {
            return;
        }
        if (this.branch) {
            if (StringUtils.equals((CharSequence)"topic", (CharSequence)qName) && !StringUtils.equals((CharSequence)IcsNaviUtil.getAttributeValue(attributes, "id"), (CharSequence)this.targetTopicId)) {
                return;
            }
            if (!StringUtils.equals((CharSequence)"topic", (CharSequence)qName) && !this.isTargetChild) {
                return;
            }
            this.isTargetChild = true;
            this.creatTopicInfo(qName, attributes);
        } else {
            this.creatTopicInfo(qName, attributes);
        }
    }

    private void creatTopicInfo(String qName, Attributes attributes) {
        if ("topic".equals(qName)) {
            this.createTopicforMeta(attributes);
        } else if (this.isTopicChild) {
            this.checkTopicChild(qName, attributes);
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "topic_meta.xml startElement unKnow qName not in topic\uff0cqName:%s ", qName));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("topics".equals(qName)) {
            return;
        }
        if ("topic".equals(qName)) {
            if (this.branch) {
                if (this.topicMetaDto != null) {
                    this.targetTopicDo = this.topicMetaDto;
                    throw new SAXException("Find target topic success.");
                }
            } else {
                this.addTopicMetaToList();
            }
            this.topicMetaDto = null;
            this.isTopicChild = false;
        } else if (this.isTopicChild) {
            this.endCheckTopicChild(qName);
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "topic_meta.xml endElement unKnow qName not in topic\uff0cqName:%s ", qName));
        }
    }

    @Override
    public void endDocument() {
        if (this.branch) {
            return;
        }
        this.endAddDto();
    }

    private void endAddDto() {
        CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "SAXParser topic_meta.xml in docId:%s", this.docId));
        this.putTopicMetaDataToDb(this.icsTopicMetaDoList);
        this.topicMetaNum += this.icsTopicMetaDoList.size();
        CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "TopicMeta total is : %d", this.topicMetaNum));
        this.putTopicRelationDataToDb(this.icsTopicRelationDtoList);
        this.topicRelationNum += this.icsTopicRelationDtoList.size();
        CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "TopicRelations total is : %d", this.topicRelationNum));
        this.icsTopicMetaDoList.clear();
        this.icsTopicRelationDtoList.clear();
    }

    private void createTopicforMeta(Attributes attributes) {
        this.isTopicChild = true;
        this.topicMetaDto = new IcsTopicMetaDo();
        this.topicMetaDto.setDocId(this.docId);
        this.topicMetaDto.setProjectId(this.projectId);
        this.topicMetaDto.setLang(this.lang);
        this.topicMetaDto.setIssuedate(this.issuedate);
        this.topicMetaDto.setName(IcsNaviUtil.getAttributeValue(attributes, "name"));
        this.topicMetaDto.setTopicId(IcsNaviUtil.getAttributeValue(attributes, "id"));
        this.topicMetaDto.setFixId(IcsNaviUtil.getAttributeValue(attributes, "fixid"));
        this.topicMetaDto.setType(IcsNaviUtil.getAttributeValue(attributes, "type"));
        this.topicMetaDto.setStatus(IcsNaviUtil.getAttributeValue(attributes, "state"));
    }

    private void addTopicMetaToList() {
        this.icsTopicMetaDoList.add(this.topicMetaDto);
        if (this.icsTopicMetaDoList.size() >= 100) {
            this.putTopicMetaDataToDb(this.icsTopicMetaDoList);
            this.topicRelationNum += this.icsTopicMetaDoList.size();
            this.icsTopicMetaDoList.clear();
        }
    }

    private void checkTopicChild(String qName, Attributes attributes) {
        if ("propertys".equals(qName)) {
            this.propertysMap = new HashMap<String, String>();
            this.queryMap = new HashMap<String, QueryMetaAndFilterDto>();
            this.isPropertyChild = true;
        } else if ("tags".equals(qName)) {
            this.tagsList = new ArrayList<QueryMetaAndFilterDto>();
            this.isTagsChild = true;
        } else if ("content".equals(qName)) {
            this.setTopicUrl(attributes);
        } else if ("relations".equals(qName)) {
            this.isRelationsChild = true;
        } else {
            this.checkChild(qName, attributes);
        }
    }

    private void checkChild(String qName, Attributes attributes) {
        if (this.isPropertyChild && "property".equals(qName)) {
            this.addTopicProperty(attributes);
        } else if (this.isTagsChild && "tag".equals(qName)) {
            this.addTopicMetaByTag(attributes);
        } else if (this.isRelationsChild && "relation".equals(qName)) {
            this.addTopicRelations(attributes);
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "topic_meta.xml checkChild unKnow qName: %s", qName));
        }
    }

    private void setTopicUrl(Attributes attributes) {
        this.topicMetaDto.setTopicUrl(attributes.getValue("url"));
    }

    private void endCheckTopicChild(String qName) {
        if ("propertys".equals(qName)) {
            this.isPropertyChild = false;
            this.topicMetaDto.setPropertysJson(JSON.toJSONString(this.propertysMap));
        } else if ("tags".equals(qName)) {
            this.isTagsChild = false;
            this.tagsList = ((Map)Optional.ofNullable(this.queryMap).orElse(new HashMap())).values().stream().collect(Collectors.toList());
            this.topicMetaDto.setTagsJson(JSON.toJSONString(this.tagsList));
        } else if ("content".equals(qName)) {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "topic_meta.xml endCheckTopicChild qName: content");
        } else if ("relations".equals(qName)) {
            this.isRelationsChild = false;
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, String.format(Locale.ENGLISH, "topic_meta.xml endCheckTopicChild unKnow qName: %s", qName));
        }
    }

    private void addTopicMetaByTag(Attributes attributes) {
        String valueId = IcsNaviUtil.getAttributeValue(attributes, "valueid");
        String value = IcsNaviUtil.getAttributeValue(attributes, "value");
        String metaNameId = IcsNaviUtil.getAttributeValue(attributes, "metanameid");
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{valueId, value, metaNameId})) {
            return;
        }
        QueryMetaAndFilterDto qmDto = Optional.ofNullable(this.queryMap.get(metaNameId)).orElse(new QueryMetaAndFilterDto());
        List valueIds = Optional.ofNullable(qmDto.getValueIds()).orElse(new ArrayList());
        List valueNames = Optional.ofNullable(qmDto.getValueNames()).orElse(new ArrayList());
        valueIds.add(valueId);
        valueNames.add(value);
        qmDto.setNameId(metaNameId);
        qmDto.setValueIds(valueIds);
        qmDto.setValueNames(valueNames);
        this.queryMap.put(metaNameId, qmDto);
    }

    private void addTopicProperty(Attributes attributes) {
        String key = IcsNaviUtil.getAttributeValue(attributes, "key");
        String value = IcsNaviUtil.getAttributeValue(attributes, "value");
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{key, value})) {
            return;
        }
        this.propertysMap.put(key, value);
    }

    private void addTopicRelations(Attributes attributes) {
        IcsTopicRelationDo relationDto = new IcsTopicRelationDo();
        String url = IcsNaviUtil.getAttributeValue(attributes, "url");
        String name = IcsNaviUtil.getAttributeValue(attributes, "name");
        String relationProjectId = IcsNaviUtil.getAttributeValue(attributes, "projectid");
        String relationTopicId = IcsNaviUtil.getAttributeValue(attributes, "topic_id");
        String relationPidId = IcsNaviUtil.getAttributeValue(attributes, "pid_id");
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{url, name, relationProjectId, relationTopicId, relationPidId})) {
            return;
        }
        relationDto.setDocId(this.docId);
        relationDto.setProjectId(this.projectId);
        relationDto.setLang(this.lang);
        relationDto.setIssuedate(this.issuedate);
        relationDto.setTopicId(this.topicMetaDto.getTopicId());
        relationDto.setUrl(url);
        relationDto.setName(name);
        relationDto.setRelationTopicId(relationTopicId);
        relationDto.setRelationPidId(relationPidId);
        relationDto.setStatus(this.topicMetaDto.getStatus());
        this.icsTopicRelationDtoList.add(relationDto);
        if (this.icsTopicRelationDtoList.size() >= 100) {
            this.putTopicRelationDataToDb(this.icsTopicRelationDtoList);
            this.topicRelationNum += this.icsTopicRelationDtoList.size();
            this.icsTopicRelationDtoList.clear();
        }
    }

    private void putTopicMetaDataToDb(List<IcsTopicMetaDo> naviTopics) {
        if (this.icsNaviTopicMetaDao != null) {
            this.icsNaviTopicMetaDao.addNaviTopicMetas(naviTopics);
        } else {
            IcsNaviTopicMetaDaoHandler.addNaviTopicMetas(ICS_TOPICMETA_MAPPER, naviTopics);
        }
    }

    private void putTopicRelationDataToDb(List<IcsTopicRelationDo> relations) {
        if (this.icsNaviTopicRelationDao != null) {
            this.icsNaviTopicRelationDao.addNaviTopicRelations(relations);
        } else {
            IcsNaviTopicRelationDaoHandler.addNaviTopicRelations(ICS_TOPICRELATION_MAPPER, relations);
        }
    }

    public IcsTopicMetaDo getTopic() {
        return this.targetTopicDo;
    }
}

