/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.parse;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.hwics.common.navi.dto.NaviXmlQueryDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.QueryMetaAndFilterDto;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParserIcsNavi
extends DefaultHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SaxParserIcsNavi.class);
    private Set<String> parentsSet = new HashSet<String>();
    private String docId;
    private String domainPidId;
    private Branch type;
    private String currentPosition;
    private boolean isParent;
    private Stack<Boolean> isFilterNavi = new Stack();
    private String preName;
    private String targetPositon;
    private String targetTopicId;
    private String targetTopicUrl;
    private List<QueryMetaAndFilterDto> queryMetas;
    private String noMetaNamePolicy = "appear";
    private StringBuffer topicsSb = new StringBuffer();
    private StringBuffer topicSb = new StringBuffer();

    public SaxParserIcsNavi(String docid, String pidId, Branch branch) {
        this.initialize(docid, pidId, branch);
    }

    public SaxParserIcsNavi(NaviXmlQueryDo topic, Branch branch) {
        this.initialize(topic.getDocId(), topic.getPidId(), branch);
        this.targetPositon = topic.getPosition();
        this.targetTopicId = topic.getTopicId();
        this.targetTopicUrl = topic.getTopicUrl();
        this.preName = "";
        this.qmsHandle(topic.getQueryMetaAndFilterDtos());
        this.positionHandle();
    }

    private void initialize(String id, String pidId, Branch branch) {
        this.docId = id;
        this.domainPidId = pidId;
        this.type = branch;
        this.topicsSb.setLength(0);
        this.topicsSb.append("[");
    }

    private void positionHandle() {
        if (StringUtils.isBlank((CharSequence)this.targetPositon)) {
            return;
        }
        String[] str = this.targetPositon.split("\\.");
        StringBuilder positionSplice = new StringBuilder(str[0]);
        this.parentsSet.add(positionSplice.toString());
        for (int i = 1; i < str.length; ++i) {
            positionSplice.append("." + str[i]);
            this.parentsSet.add(positionSplice.toString());
        }
    }

    private void qmsHandle(List<QueryMetaAndFilterDto> queryMetaAndFilterDtos) {
        this.queryMetas = new ArrayList<QueryMetaAndFilterDto>();
        if (CollectionUtils.isNotEmpty(queryMetaAndFilterDtos)) {
            queryMetaAndFilterDtos.stream().forEach(qms -> {
                if (!StringUtils.equals((CharSequence)qms.getTopicFilter(), (CharSequence)"true")) {
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)qms.getNoMetaNamePolicy(), (CharSequence)"appear") || StringUtils.equalsIgnoreCase((CharSequence)qms.getNoMetaNamePolicy(), (CharSequence)"disappear")) {
                    this.noMetaNamePolicy = qms.getNoMetaNamePolicy();
                }
                this.queryMetas.add((QueryMetaAndFilterDto)qms);
            });
        }
        if (CollectionUtils.isNotEmpty(this.queryMetas)) {
            this.type = Branch.ALLNAVISWITHQMS;
            this.currentPosition = ".0";
        }
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) {
        if (StringUtils.equals((CharSequence)"topic", (CharSequence)qname)) {
            if (this.type == Branch.ALLNAVISWITHQMS) {
                this.setFilterNavis(attributes);
            } else {
                this.addTopic();
                switch (this.type) {
                    case ALLNAVIS: {
                        this.setAllNavis(attributes);
                        break;
                    }
                    case FIRSTFLOOR: {
                        this.setFirstFloorTopics(attributes);
                        break;
                    }
                    case GETBYPOSITION: {
                        this.setTopicsByPosition(attributes);
                        break;
                    }
                    case GETCHILD: {
                        this.setChilds(attributes);
                        break;
                    }
                    case FINDBYURL: {
                        this.findByUrl(attributes);
                        break;
                    }
                    case FINDBYID: {
                        this.findById(attributes);
                        break;
                    }
                    default: {
                        CodeCCUtils.INSTANCE.debugLog(LOGGER, "{0}, startElement unKnow qName:{1} ", new Object[]{this.docId, qname});
                        break;
                    }
                }
            }
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "{0}, startElement unKnow qName:{1} ", new Object[]{this.docId, qname});
        }
    }

    private void findByUrl(Attributes attributes) {
        if (StringUtils.isNotBlank((CharSequence)this.targetPositon) || !StringUtils.equals((CharSequence)this.targetTopicUrl, (CharSequence)attributes.getValue("url"))) {
            return;
        }
        this.targetPositon = attributes.getValue("position");
    }

    private void findById(Attributes attributes) {
        if (StringUtils.isNotBlank((CharSequence)this.targetPositon) || !StringUtils.equals((CharSequence)this.targetTopicId, (CharSequence)attributes.getValue("id"))) {
            return;
        }
        this.targetPositon = attributes.getValue("position");
    }

    private void setTopicsByPosition(Attributes attributes) {
        String parentPosition = attributes.getValue("parentPosition");
        if (StringUtils.isNotBlank((CharSequence)parentPosition) && !this.parentsSet.contains(parentPosition)) {
            return;
        }
        this.creatTopic(attributes);
    }

    private void setChilds(Attributes attributes) {
        if (this.parentsSet.isEmpty() || !StringUtils.equals((CharSequence)attributes.getValue("parentPosition"), (CharSequence)this.targetPositon)) {
            return;
        }
        this.creatTopic(attributes);
    }

    private void setFirstFloorTopics(Attributes attributes) {
        String position = attributes.getValue("position");
        if (position.indexOf(".") >= 0) {
            return;
        }
        this.creatTopic(attributes);
    }

    private void setAllNavis(Attributes attributes) {
        this.creatTopic(attributes);
    }

    private void setFilterNavis(Attributes attributes) {
        if (this.filterNavi(attributes)) {
            if (!this.isFilterNavi.isEmpty()) {
                this.isFilterNavi.push(false);
            }
            return;
        }
        this.isFilterNavi.push(true);
        if (this.topicSb.length() > 0) {
            this.topicSb.append(String.format(Locale.ENGLISH, "\"isParent\":\"%s\",", String.valueOf(this.isParent)));
            this.topicSb.append(String.format(Locale.ENGLISH, "\"nextName\":\"%s\"", this.string2Json(attributes.getValue("txt"))));
        }
        this.addTopic();
        this.isParent = true;
        this.topicSb.append("{");
        this.getTopicBaseInfo(attributes);
        this.topicSb.append(String.format(Locale.ENGLISH, "\"position\":\"%s\",", this.string2Json(this.getCurrentPosition())));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"parentPosition\":\"%s\",", this.string2Json(this.getParentPosition())));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"preName\":\"%s\",", this.string2Json(this.preName)));
        this.preName = attributes.getValue("txt");
        this.positionPush();
    }

    private boolean filterNavi(Attributes attributes) {
        String tagsStr = attributes.getValue("tags");
        for (QueryMetaAndFilterDto valueDto : this.queryMetas) {
            if (StringUtils.equalsIgnoreCase((CharSequence)this.noMetaNamePolicy, (CharSequence)"appear")) {
                if (StringUtils.isBlank((CharSequence)tagsStr) || StringUtils.equalsIgnoreCase((CharSequence)tagsStr, (CharSequence)"[]") || this.isContains(valueDto, tagsStr)) continue;
                return true;
            }
            if (this.isContains(valueDto, tagsStr)) continue;
            return true;
        }
        return false;
    }

    private boolean isContains(QueryMetaAndFilterDto valueDto, String tagsStr) {
        boolean isContainFlag = false;
        Map<String, List> tagsMap = ((List)Optional.ofNullable(tagsStr).map(tagsJson -> JSON.parseArray((String)tagsJson, QueryMetaAndFilterDto.class)).orElse(new ArrayList())).stream().collect(Collectors.toMap(QueryMetaAndFilterDto::getNameId, QueryMetaAndFilterDto::getValueIds));
        if (tagsMap.containsKey(valueDto.getNameId())) {
            for (String valueId : valueDto.getValueIds()) {
                if (!tagsMap.get(valueDto.getNameId()).contains(valueId)) continue;
                isContainFlag = true;
            }
        }
        return isContainFlag;
    }

    private void creatTopic(Attributes attributes) {
        this.topicSb.append("{");
        this.getTopicBaseInfo(attributes);
        this.topicSb.append(String.format(Locale.ENGLISH, "\"position\":\"%s\",", this.string2Json(attributes.getValue("position"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"parentPosition\":\"%s\",", this.string2Json(attributes.getValue("parentPosition"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"isParent\":\"%s\",", this.string2Json(attributes.getValue("isParent"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"preName\":\"%s\",", this.string2Json(attributes.getValue("preName"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"nextName\":\"%s\"", this.string2Json(attributes.getValue("nextName"))));
    }

    private void getTopicBaseInfo(Attributes attributes) {
        this.topicSb.append(String.format(Locale.ENGLISH, "\"docId\":\"%s\",", this.string2Json(attributes.getValue("docId"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"pidId\":\"%s\",", this.string2Json(attributes.getValue("pidId"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"topicId\":\"%s\",", this.string2Json(attributes.getValue("id"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"topicUrl\":\"%s\",", this.string2Json(attributes.getValue("url"))));
        this.topicSb.append(String.format(Locale.ENGLISH, "\"name\":\"%s\",", this.string2Json(attributes.getValue("txt"))));
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if ("topic".equals(qname)) {
            if (this.type == Branch.ALLNAVISWITHQMS) {
                this.isParent = false;
                if (!this.isFilterNavi.isEmpty() && this.isFilterNavi.pop().booleanValue()) {
                    this.positionPop();
                }
                return;
            }
            this.addTopic();
        } else {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "{0}, endElement unKnow qName:{1} ", new Object[]{this.docId, qname});
        }
    }

    @Override
    public void endDocument() {
        this.addTopic();
        this.topicsSb.replace(this.topicsSb.length() - 1, this.topicsSb.length(), "]");
    }

    private void addTopic() {
        if (this.topicSb.length() <= 0) {
            return;
        }
        if (this.type == Branch.ALLNAVISWITHQMS && StringUtils.equals((CharSequence)this.topicSb.substring(this.topicSb.length() - 1), (CharSequence)",")) {
            this.topicSb.append("\"nextName\":\"\"");
        }
        this.topicSb.append("},");
        this.topicsSb.append(this.topicSb);
        this.topicSb.setLength(0);
    }

    public String getPostion() {
        return this.targetPositon;
    }

    public String getTopicStr() {
        if (this.topicsSb.length() <= 1) {
            return JSON.toJSONString(new ArrayList());
        }
        return this.topicsSb.toString();
    }

    private String getParentPosition() {
        int index = this.currentPosition.lastIndexOf(".");
        if (index <= 0) {
            return "";
        }
        return this.currentPosition.substring(1, index);
    }

    private String getCurrentPosition() {
        int index = this.currentPosition.lastIndexOf(".");
        int position = Integer.parseInt(this.currentPosition.substring(index + 1)) + 1;
        this.currentPosition = this.currentPosition.substring(0, index) + "." + position;
        return this.currentPosition.substring(1);
    }

    private void positionPush() {
        this.currentPosition = this.currentPosition + ".0";
    }

    private void positionPop() {
        int index = this.currentPosition.lastIndexOf(".");
        this.currentPosition = this.currentPosition.substring(0, index);
    }

    private String string2Json(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                case '/': {
                    sb.append("\\/");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static enum Branch {
        ALLNAVIS,
        ALLNAVISWITHQMS,
        FIRSTFLOOR,
        GETBYPOSITION,
        GETCHILD,
        FINDBYURL,
        FINDBYID;

    }
}

