/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.parse;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.TopicXmlInfoDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMetaMapper;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.wsf.core.HWEncoder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParserPid
extends DefaultHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SaxParserPid.class);
    private static final IcsNaviTopicMetaMapper ICS_TOPICMETA_MAPPER = (IcsNaviTopicMetaMapper)DbMapperUtils.getMapper(IcsNaviTopicMetaMapper.class);
    private static final String FAILEDVALUE = "true";
    private static final int MAXTIMES = 5;
    private static final int MAXLENGTH = 10000;
    private static final String ATTRSTART = "=\"";
    private static final String ATTREND = "\" ";
    private static final String TOPICEND = "</topic>";
    private static final String TOPIC_NODE_TEMPLATE = "<topic docId=\"%s\" pidId=\"%s\" txt=\"%s\" position=\"%s\" parentPosition=\"%s\" id=\"%s\" url=\"%s\" tags=\"%s\" preName=\"%s\" ";
    private final Stack<TopicXmlInfoDo> topicInfoStack = new Stack();
    private IcsNaviTopicMetaDao icsNaviTopicMetaDao;
    private String rootDocId;
    private String pidId;
    private String filePath;
    private Map<String, String> paths;
    private StringBuilder mergeStringBuf = new StringBuilder();
    private int times;
    private String parentTopicId;
    private Stack<Integer> pathStack = new Stack();
    private int currentIndex = 1;
    private TopicXmlInfoDo preTopicXmlInfoDo;
    private boolean isParent;
    private int endTimes = 0;
    private StringBuilder tempEnd = new StringBuilder();

    public SaxParserPid(String filePath, int times) {
        this.filePath = filePath;
        this.times = times;
        if (this.times == 0) {
            this.writerContent(filePath, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><topics>", false);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) {
        TopicXmlInfoDo topicXmlInfoDo;
        if (!"topic".equals(qname)) {
            return;
        }
        TopicXmlInfoDo parentTopic = this.topicInfoStack.isEmpty() ? new TopicXmlInfoDo() : this.topicInfoStack.peek();
        String tempParentTopicId = (String)StringUtils.defaultIfBlank((CharSequence)this.parentTopicId, (CharSequence)parentTopic.getTopicId());
        this.preTopicXmlInfoDo = topicXmlInfoDo = this.createTopicElement(attributes, tempParentTopicId);
        this.topicInfoStack.push(topicXmlInfoDo);
        if (StringUtils.equals((CharSequence)topicXmlInfoDo.getTopicId(), (CharSequence)FAILEDVALUE)) {
            this.pathStack.push(-1);
        } else if (!StringUtils.equals((CharSequence)topicXmlInfoDo.getDocId(), (CharSequence)FAILEDVALUE)) {
            this.pathStack.push(this.currentIndex);
            this.currentIndex = 1;
            this.addTopicEndToSb(topicXmlInfoDo.getName());
            this.addTopicToMergeStringBuf(topicXmlInfoDo);
        }
        if (StringUtils.equals((CharSequence)topicXmlInfoDo.getDocId(), (CharSequence)FAILEDVALUE)) {
            this.pathStack.push(-1);
        }
        this.isParent = true;
    }

    private void addTopicEndToSb(String nextName) {
        if (this.mergeStringBuf.length() <= 0) {
            return;
        }
        if (this.mergeStringBuf.length() >= 10000) {
            this.writerContent(this.filePath, this.mergeStringBuf.toString(), true);
            this.mergeStringBuf.setLength(0);
        }
        this.mergeStringBuf.append("isParent=\"").append(this.isParent).append(ATTREND);
        this.mergeStringBuf.append("nextName=\"").append(HWEncoder.encodeForXMLAttribute((String)nextName)).append(ATTREND);
        this.mergeStringBuf.append(">");
        if (!this.isParent) {
            --this.endTimes;
            this.mergeStringBuf.append((CharSequence)this.tempEnd);
            this.tempEnd.setLength(0);
        }
    }

    private void addTopicToMergeStringBuf(TopicXmlInfoDo tempTopic) {
        if (StringUtils.equals((CharSequence)tempTopic.getTopicId(), (CharSequence)FAILEDVALUE)) {
            return;
        }
        this.mergeStringBuf.append(String.format(Locale.ENGLISH, TOPIC_NODE_TEMPLATE, this.encodeForXmlAttr(tempTopic.getDocId()), this.encodeForXmlAttr(tempTopic.getPidId()), this.encodeForXmlAttr(tempTopic.getName()), this.encodeForXmlAttr(this.getCurPosition()), this.encodeForXmlAttr(this.getParentPosition()), this.encodeForXmlAttr(tempTopic.getTopicId()), this.encodeForXmlAttr(tempTopic.getTopicUrl()), this.encodeForXmlAttr(tempTopic.getTagsJson()), this.encodeForXmlAttr(tempTopic.getPreName())));
    }

    private String getCurPosition() {
        return StringUtils.join(this.pathStack, (String)".");
    }

    private String getParentPosition() {
        return StringUtils.join(this.pathStack.subList(0, this.pathStack.size() - 1), (String)".");
    }

    private String encodeForXmlAttr(String attr) {
        return HWEncoder.encodeForXMLAttribute((String)((String)StringUtils.defaultIfBlank((CharSequence)attr, (CharSequence)"")));
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (!"topic".equals(qname)) {
            return;
        }
        TopicXmlInfoDo currentTopic = this.topicInfoStack.pop();
        if (!StringUtils.equals((CharSequence)currentTopic.getTopicId(), (CharSequence)FAILEDVALUE) && !StringUtils.equals((CharSequence)currentTopic.getDocId(), (CharSequence)FAILEDVALUE)) {
            this.tempEnd.append(TOPICEND);
            if (this.isParent) {
                ++this.endTimes;
            }
        }
        this.isParent = false;
        int lastLevelIndex = this.pathStack.pop();
        this.currentIndex = lastLevelIndex == -1 ? this.currentIndex : lastLevelIndex + 1;
    }

    @Override
    public void endDocument() {
        if (this.times < 1) {
            this.addTopicEndToSb("");
        }
        while (this.times < 1 && this.endTimes-- > 0) {
            this.mergeStringBuf.append(TOPICEND);
        }
        if (this.times < 1) {
            this.mergeStringBuf.append("</topics>");
            this.writerContent(this.filePath, this.mergeStringBuf.toString(), true);
        }
    }

    private void writerContent(String path, String content, boolean append) {
        boolean isMkdirs;
        File file = FileUtils.getFile((String[])new String[]{path});
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !(isMkdirs = parentFile.mkdirs())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "FileUtil writeFileContent fail.");
            return;
        }
        try (BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)file, (boolean)append), StandardCharsets.UTF_8));){
            fileWriter.write(content);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "FileUtil writeFileContent error.", (Throwable)e);
        }
    }

    private TopicXmlInfoDo createTopicElement(Attributes attributes, String parentTopicId) {
        TopicXmlInfoDo topicXmlInfoDo = new TopicXmlInfoDo();
        String topicId = IcsNaviUtil.getAttributeValue(attributes, "id");
        String rePidId = IcsNaviUtil.getAttributeValue(attributes, "pid_id");
        if (StringUtils.isNotBlank((CharSequence)rePidId)) {
            topicXmlInfoDo = this.parseRefPid(rePidId, parentTopicId);
            if (topicXmlInfoDo == null) {
                topicXmlInfoDo = new TopicXmlInfoDo();
                topicXmlInfoDo.setTopicId(FAILEDVALUE);
            } else {
                topicXmlInfoDo.setDocId(FAILEDVALUE);
            }
        } else {
            String name = IcsNaviUtil.getAttributeValue(attributes, "name");
            topicXmlInfoDo.setDocId(this.rootDocId);
            topicXmlInfoDo.setPidId(this.pidId);
            topicXmlInfoDo.setName(name);
            topicXmlInfoDo.setIsParent("false");
            topicXmlInfoDo.setTopicId(topicId);
            topicXmlInfoDo.setParentTopicId(parentTopicId);
            if (StringUtils.isNotBlank((CharSequence)topicId)) {
                this.setTopicMetaInfo(topicId, topicXmlInfoDo);
            }
            topicXmlInfoDo.setPreName(this.preTopicXmlInfoDo == null ? "" : this.preTopicXmlInfoDo.getName());
        }
        return topicXmlInfoDo;
    }

    private void setTopicMetaInfo(String reTopicId, TopicXmlInfoDo topic) {
        for (String docId : this.paths.keySet()) {
            IcsTopicDo topicMeta = this.getTopicMetaData(docId, reTopicId);
            if (topicMeta == null) continue;
            topic.setDocId(docId);
            topic.setTagsJson(topicMeta.getTagsJson());
            String topicUrl = topicMeta.getTopicUrl();
            if (StringUtils.isBlank((CharSequence)topicUrl)) {
                CodeCCUtils.INSTANCE.warnLog(LOGGER, "Topic[{0}] don't get all topic meta, id[{1}]-name[{2}]-ctime[{3}],", new Object[]{reTopicId, topicMeta.getTopicId(), topicMeta.getName(), topicMeta.getCtime().toString()});
                continue;
            }
            topic.setTopicUrl(topicUrl);
            break;
        }
    }

    private IcsTopicDo getTopicMetaData(String docId, String topicId) {
        if (this.icsNaviTopicMetaDao == null) {
            return IcsNaviTopicMetaDaoHandler.getTopicByDocId(ICS_TOPICMETA_MAPPER, docId, topicId);
        }
        return this.icsNaviTopicMetaDao.getTopicByDocId(docId, topicId);
    }

    private TopicXmlInfoDo parseRefPid(String rePidId, String parentTopicId) {
        TopicXmlInfoDo topicXmlInfoDo = null;
        if (this.times + 1 > 5) {
            return topicXmlInfoDo;
        }
        for (Map.Entry<String, String> it : this.paths.entrySet()) {
            String docId = it.getKey();
            String pidPath = String.format(Locale.ENGLISH, "resources/infocenter_service/map/%s.xml", rePidId);
            try {
                InputStream is = ZipFilePool.getInputStream((String)it.getValue(), (String)pidPath);
                Throwable throwable = null;
                try {
                    if (is == null) {
                        CodeCCUtils.INSTANCE.infoLog(LOGGER, "{0}.xml is not found in[{1}].", new Object[]{rePidId, docId});
                        continue;
                    }
                    SaxParserPid saxParser = new SaxParserPid(this.filePath, this.times + 1).setIcsNaviTopicMetaDao(this.icsNaviTopicMetaDao).setRootDocId(docId).setPidId(this.pidId).setParentTopicId(parentTopicId).setIsParent(this.isParent).setPreTopicXmlInfoDo(this.preTopicXmlInfoDo).setTempEnd(this.tempEnd).setMergeStringBuf(this.mergeStringBuf).setFilePath(this.filePath).setPaths(this.paths).setPathStack(this.pathStack).setCurrentIndex(this.currentIndex);
                    SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
                    topicXmlInfoDo = saxParser.getLastTopic();
                    if (topicXmlInfoDo == null) break;
                    this.tempEnd = Optional.ofNullable(saxParser.getTempEnd()).orElse(this.tempEnd);
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | SAXException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Error parserXml {0}.xml.", (Throwable)e, new Object[]{rePidId});
            }
        }
        return topicXmlInfoDo;
    }

    public TopicXmlInfoDo getLastTopic() {
        return this.preTopicXmlInfoDo;
    }

    public StringBuilder getTempEnd() {
        return this.tempEnd;
    }

    public SaxParserPid setIsParent(boolean isParent) {
        this.isParent = isParent;
        return this;
    }

    public SaxParserPid setIcsNaviTopicMetaDao(IcsNaviTopicMetaDao icsNaviTopicMetaDao) {
        this.icsNaviTopicMetaDao = icsNaviTopicMetaDao;
        return this;
    }

    public SaxParserPid setRootDocId(String rootDocId) {
        this.rootDocId = rootDocId;
        return this;
    }

    public SaxParserPid setPidId(String pidId) {
        this.pidId = pidId;
        return this;
    }

    public SaxParserPid setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public SaxParserPid setPaths(Map<String, String> paths) {
        this.paths = paths;
        return this;
    }

    public SaxParserPid setMergeStringBuf(StringBuilder mergeStringBuf) {
        this.mergeStringBuf = mergeStringBuf;
        return this;
    }

    public SaxParserPid setTimes(int times) {
        this.times = times;
        return this;
    }

    public SaxParserPid setParentTopicId(String parentTopicId) {
        this.parentTopicId = parentTopicId;
        return this;
    }

    public SaxParserPid setPathStack(Stack<Integer> pathStack) {
        this.pathStack = pathStack;
        return this;
    }

    public SaxParserPid setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
        return this;
    }

    public SaxParserPid setPreTopicXmlInfoDo(TopicXmlInfoDo preTopicXmlInfoDo) {
        this.preTopicXmlInfoDo = preTopicXmlInfoDo;
        return this;
    }

    public SaxParserPid setEndTimes(int endTimes) {
        this.endTimes = endTimes;
        return this;
    }

    public SaxParserPid setTempEnd(StringBuilder tempEnd) {
        this.tempEnd = tempEnd;
        return this;
    }
}

