/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicRelationDao;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicBaseDo;
import com.huawei.support.icscbb.hwics.common.navi.parse.SAXParserNavi;
import com.huawei.support.icscbb.hwics.common.navi.parse.SAXParserTopicMeta;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class IcsNaviServiceCommonMethod {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviServiceCommonMethod.class);

    IcsNaviServiceCommonMethod() {
    }

    protected static IcsNaviStatusDo getUpdateStatusDo(IcsNaviStatusDo statusDo, String newStatus) {
        String status = statusDo.getStatus();
        String update = newStatus;
        if (IcsNaviServiceCommonMethod.isUpdateStatus(status)) {
            switch (update) {
                case "101": {
                    update = "201";
                    break;
                }
                case "102": {
                    update = "202";
                    break;
                }
                case "100": {
                    update = "200";
                    break;
                }
                case "103": {
                    update = "203";
                    break;
                }
            }
        }
        statusDo.setStatus(update);
        return statusDo;
    }

    protected static boolean isUpdateStatus(String status) {
        return StringUtils.equalsAny((CharSequence)"201", (CharSequence[])new CharSequence[]{"202", "200", "203"});
    }

    protected static boolean parsePid(String docPath, IcsTopicBaseDo profile, List<String> pids, IcsNaviTopicDao icsNaviTopicDao) {
        boolean isSuccess = true;
        for (String pidId : pids) {
            String filePath = "resources/infocenter_service/map/" + pidId + ".xml";
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "pid filePath" + filePath);
            try {
                InputStream is = ZipFilePool.getInputStream((String)docPath, (String)filePath);
                Throwable throwable = null;
                try {
                    if (is == null) {
                        CodeCCUtils.INSTANCE.infoLog(LOGGER, String.format(Locale.ENGLISH, "%s.xml is not found.", pidId));
                        continue;
                    }
                    SAXParserNavi saxParser = new SAXParserNavi(profile, pidId, icsNaviTopicDao);
                    SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | SAXException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, String.format(Locale.ENGLISH, "Error parserXml %s.xml.", pidId), (Throwable)e);
                isSuccess = false;
            }
        }
        return isSuccess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean parseMeta(String docPath, IcsTopicBaseDo profile, IcsNaviTopicMetaDao icsNaviTopicMetaDao, IcsNaviTopicRelationDao icsNaviTopicRelationDao) {
        boolean isSuccess = false;
        String filePath = "resources/infocenter_service/metadata/topic_meta.xml";
        try (InputStream is = ZipFilePool.getInputStream((String)docPath, (String)filePath);){
            if (is == null) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "topic_meta.xml is not found.");
                boolean bl = isSuccess;
                return bl;
            }
            SAXParserTopicMeta saxParser = new SAXParserTopicMeta(profile, icsNaviTopicMetaDao, icsNaviTopicRelationDao);
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
            isSuccess = true;
            return isSuccess;
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Error parserXml topic_meta.xml", (Throwable)e);
        }
        return isSuccess;
    }

    protected static Map<String, String> modifyMapOrder(String docId, Map<String, String> rePaths) {
        LinkedHashMap<String, String> temp = new LinkedHashMap<String, String>();
        temp.put(docId, rePaths.get(docId));
        rePaths.forEach((key, value) -> {
            if (StringUtils.equals((CharSequence)docId, (CharSequence)key)) {
                return;
            }
            temp.put((String)key, (String)value);
        });
        return temp;
    }
}

