/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviStatusDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviStatusMapper;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviStatusService;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsNaviStatusServiceHandler
implements IcsNaviStatusService {
    private static final IcsNaviStatusMapper ICS_STATUS_MAPPER = (IcsNaviStatusMapper)DbMapperUtils.getMapper(IcsNaviStatusMapper.class);

    private IcsNaviStatusServiceHandler() {
    }

    public static IcsNaviStatusServiceHandler getInstance() {
        return IcsNaviStatusHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        IcsNaviStatusDaoHandler.createNaviTopicTb(ICS_STATUS_MAPPER);
    }

    @Override
    public void addList(List<IcsNaviStatusDo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        IcsNaviStatusDaoHandler.addList(ICS_STATUS_MAPPER, list);
    }

    @Override
    public void add(IcsNaviStatusDo statusDo) {
        if (statusDo == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{statusDo.getDocId(), statusDo.getStatus()})) {
            return;
        }
        IcsNaviStatusDaoHandler.add(ICS_STATUS_MAPPER, statusDo);
    }

    @Override
    public void delete(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            return;
        }
        IcsNaviStatusDaoHandler.delete(ICS_STATUS_MAPPER, docId);
    }

    @Override
    public boolean deleteAll() {
        return IcsNaviStatusDaoHandler.deleteAll(ICS_STATUS_MAPPER);
    }

    @Override
    public IcsNaviStatusDo getPidByDocId(String docId, String pidId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId})) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("docId", docId);
        map.put("pidId", pidId);
        return IcsNaviStatusDaoHandler.getPidByDocId(ICS_STATUS_MAPPER, map);
    }

    @Override
    public List<IcsNaviStatusDo> getDocStatusByDocId(String docId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId})) {
            return new ArrayList<IcsNaviStatusDo>();
        }
        return IcsNaviStatusDaoHandler.getDocStatusByDocId(ICS_STATUS_MAPPER, docId);
    }

    @Override
    public void updateStatus(IcsNaviStatusDo statusDo) {
        if (statusDo == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{statusDo.getDocId(), statusDo.getStatus()})) {
            return;
        }
        IcsNaviStatusDaoHandler.updateStatus(ICS_STATUS_MAPPER, statusDo);
    }

    @Override
    public List<String> getDocIdsByStatus(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return IcsNaviStatusDaoHandler.getDocIdsByStatus(ICS_STATUS_MAPPER, list);
    }

    @Override
    public List<IcsNaviStatusDo> getUnfinishedDoc() {
        return IcsNaviStatusDaoHandler.getUnfinishedDoc(ICS_STATUS_MAPPER);
    }

    private static class IcsNaviStatusHandlerHolder {
        private static final IcsNaviStatusServiceHandler INSTANCE = new IcsNaviStatusServiceHandler();

        private IcsNaviStatusHandlerHolder() {
        }
    }
}

