/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviStatusDao;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviStatusService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcsNaviStatusServiceImpl
implements IcsNaviStatusService {
    @Autowired
    IcsNaviStatusDao icsNaviStatusDao;

    @Override
    public void createTb() {
        this.icsNaviStatusDao.createNaviTopicTb();
    }

    @Override
    public void addList(List<IcsNaviStatusDo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.icsNaviStatusDao.addList(list);
    }

    @Override
    public void add(IcsNaviStatusDo statusDo) {
        if (statusDo == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{statusDo.getDocId(), statusDo.getStatus()})) {
            return;
        }
        this.icsNaviStatusDao.add(statusDo);
    }

    @Override
    public void delete(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            return;
        }
        this.icsNaviStatusDao.delete(docId);
    }

    @Override
    public boolean deleteAll() {
        return false;
    }

    @Override
    public IcsNaviStatusDo getPidByDocId(String docId, String pidId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId})) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("docId", docId);
        map.put("pidId", pidId);
        return this.icsNaviStatusDao.getPidByDocId(map);
    }

    @Override
    public List<IcsNaviStatusDo> getDocStatusByDocId(String docId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId})) {
            return new ArrayList<IcsNaviStatusDo>();
        }
        return this.icsNaviStatusDao.getDocStatusByDocId(docId);
    }

    @Override
    public void updateStatus(IcsNaviStatusDo statusDo) {
        if (statusDo == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{statusDo.getDocId(), statusDo.getStatus()})) {
            return;
        }
        this.icsNaviStatusDao.updateStatus(statusDo);
    }

    @Override
    public List<String> getDocIdsByStatus(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return this.icsNaviStatusDao.getDocIdsByStatus(list);
    }

    @Override
    public List<IcsNaviStatusDo> getUnfinishedDoc() {
        return this.icsNaviStatusDao.getUnfinishedDoc();
    }
}

